<?php
namespace Ignite\Theme\Tests;

use Ignite\Theme\Factory;
use Ignite\Theme\Theme;

class FactoryTest extends TestCase
{
    /**
     * @test
     */
    public function it_can_create_a_theme_instance()
    {
        $factory = new Factory();
        $theme = new \stdClass();
        $theme->name = 'test';
        $theme->path = __DIR__;
        $theme->description = 'The test theme';
        $theme->parent = null;

        $this->assertInstanceOf(Theme::class, $factory->create($theme));
    }

    /**
     * @test
     */
    public function it_can_create_a_theme_from_an_expected_json_structure()
    {
        $factory = new Factory();

        $json = '{"name":"test","path":"/home/root/project/themes/test","description":""}';

        $this->assertInstanceOf(Theme::class, $factory->fromJson($json));
    }

    /**
     * @test
     */
    public function it_throws_correct_exception_when_json_decode_fails()
    {
        $this->expectException(\Ignite\Theme\Exception\JsonDecodeException::class);

        $factory = new Factory();

        $json = '{"name":"test","path":"/home/root/project/themes/test","description:""}';

        $factory->fromJson($json);
    }

    /**
     * @test
     */
    public function it_can_create_a_theme_from_a_json_file_and_overwrite_the_path()
    {
        $factory = new Factory();

        $json = '{"name":"test","description":"","path":"/home/root/project/themes/test"}';

        $theme = $factory->fromJson($json, '/stubs/parent/theme.json');

        $this->assertInstanceOf(Theme::class, $theme);
        $this->assertSame('/stubs/parent', $theme->path());
    }

    /**
     * @test
     */
    public function it_can_create_a_theme_from_a_json_file()
    {
        $stub = __DIR__ . '/stubs/parent/theme.json';

        $factory = new Factory();

        $this->assertInstanceOf(Theme::class, $factory->fromPath($stub));
    }

    /**
     * @test
     */
    public function it_can_create_a_theme_from_a_path_without_the_filename()
    {
        $stub = __DIR__ . '/stubs/parent/';

        $factory = new Factory();

        $this->assertInstanceOf(Theme::class, $factory->fromPath($stub));
    }

    /**
     * @test
     */
    public function it_throws_correct_exception_the_json_file_is_missing()
    {
        $this->expectException(\Ignite\Theme\Exception\JsonNotFoundException::class);

        $stub = __DIR__ . '/theme.json';

        $factory = new Factory();

        $factory->fromPath($stub);
    }

    /**
     * @test
     */
    public function it_can_create_a_theme_with_a_parent()
    {
        $stub = __DIR__ . '/stubs/child/theme.json';

        $factory = new Factory();

        $theme = $factory->fromPath($stub);

        $this->assertTrue($theme->isChild());
    }
}
