<?php
namespace Ignite\Theme\Tests;

use Ignite\Theme\ThemeServiceProvider;

class ThemeServiceProviderTest extends TestCase
{
    /**
     * @test
     */
    public function it_registers_the_provider()
    {
        $this->assertInstanceOf(
            ThemeServiceProvider::class,
            $this->app->resolveProvider(ThemeServiceProvider::class)
        );
    }

    /**
     * @test
     */
    public function it_registers_the_configuration_file_publish_location()
    {
        $group = 'theme';

        $this->assertArrayHasKey($group, ThemeServiceProvider::$publishGroups);

        $this->assertArrayHasKey(
            str_replace('/tests', '/src', __DIR__) . '/../config/theme.php',
            ThemeServiceProvider::$publishGroups[$group]
        );

        $this->assertContains(
            config_path('theme.php'),
            ThemeServiceProvider::$publishGroups[$group]
        );
    }

    /**
     * @test
     */
    public function it_registers_the_publish_command()
    {
        /** @var \Illuminate\Console\Application $console */
        $console = $this->app->make(\Illuminate\Console\Application::class, [
            'version' => $this->app->version()
        ]);

        $this->assertTrue($console->has('ignite:theme:publish'));
    }

    /**
     * @test
     */
    public function it_registers_the_scaffold_command()
    {
        /** @var \Illuminate\Console\Application $console */
        $console = $this->app->make(\Illuminate\Console\Application::class, [
            'version' => $this->app->version()
        ]);

        $this->assertTrue($console->has('ignite:theme:scaffold'));
    }

    /**
     * @test
     */
    public function it_registers_the_manager_class_in_the_container()
    {
        $this->assertTrue($this->app->bound(\Ignite\Theme\Manager::class));
    }

    /**
     * @test
     */
    public function it_aliases_the_manager_class_in_the_container_as_theme()
    {
        $this->assertSame(\Ignite\Theme\Manager::class, $this->app->getAlias('theme'));
    }

    /**
     * @test
     */
    public function it_provides_the_theme_class()
    {
        $this->assertContains(
            'theme',
            $this->app->resolveProvider(ThemeServiceProvider::class)->provides()
        );
    }

    /**
     * @test
     */
    public function it_provides_the_theme_assets_class()
    {
        $this->assertContains(
            'theme.asset',
            $this->app->resolveProvider(ThemeServiceProvider::class)->provides()
        );
    }
}
