<?php

namespace Ignite\Theme\Exception;

use Exception;
use Throwable;

class ThemeNotFoundException extends Exception
{
    /**
     * ThemeNotFoundException constructor.
     *
     * @param string $theme
     * @param int $code
     * @param Throwable|null $previous
     */
    public function __construct($theme = "", $code = 0, Throwable $previous = null)
    {
        parent::__construct("Theme '$theme' is not registered.", $code, $previous);
    }
}
