<?php

namespace Ignite\Theme;

use Ignite\Theme\Console\PublishCommand;
use Ignite\Theme\Console\ScaffoldCommand;
use Ignite\Theme\Console\ThemeBuildCommand;
use Illuminate\Contracts\Container\Container;
use Illuminate\Support\ServiceProvider;

class ThemeServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Boot the service provider.
     */
    public function boot()
    {

    }

    /**
     * Register dependencies.
     */
    public function register()
    {
        $this->registerConfiguration();
        $this->registerAliases();
        $this->registerCommands();
    }

    /**
     * Register the configuration file.
     */
    protected function registerConfiguration()
    {
        $this->mergeConfigFrom(__DIR__ . '/../config/theme.php', 'theme');

        $this->publishes([
            __DIR__ . '/../config/theme.php' => config_path('theme.php')
        ], 'theme');
    }

    /**
     * Register console commands.
     */
    private function registerCommands()
    {
        $this->commands([
            ScaffoldCommand::class,
            ThemeBuildCommand::class,
            PublishCommand::class,
        ]);
    }

    /**
     * Register class aliases.
     */
    private function registerAliases()
    {
        // @codeCoverageIgnoreStart
        $this->app->singleton(Manager::class, function (Container $app) {
            $manager = new Manager($app->make(Factory::class), $app);

            foreach ($app['config']->get('theme.paths', []) as $path) {
                $manager->registerPaths($manager->discover($path));
            }

            return $manager;
        });

        $this->app->singleton(Asset::class, function (Container $app) {
            return new Asset(
                $app->make(Manager::class),
                $app->make(UrlGenerator::class)
            );
        });
        // @codeCoverageIgnoreEnd

        $this->app->alias(Manager::class, 'theme');
        $this->app->alias(Asset::class, 'theme.asset');

        $manager = $this->app->make(Manager::class);
        if (! empty($activeTheme = $this->app['config']->get('theme.activate', null))) {
            $manager->activate($activeTheme);
        }
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return [
            'theme', 'theme.asset'
        ];
    }
}
