<?php

namespace Ignite\Theme\Tests;

use Ignite\Theme\ThemeServiceProvider;
use Orchestra\Testbench\TestCase as OrchestraTestCase;

class TestCase extends OrchestraTestCase
{
    /**
     * @var array
     */
    protected $paths = [
        __DIR__ . '/stubs'
    ];

    /**
     * @var string
     */
    protected $activate = 'parent';

    /**
     * Resolve application core configuration implementation.
     *
     * @param  \Illuminate\Foundation\Application  $app
     *
     * @return void
     */
    protected function resolveApplicationConfiguration($app)
    {
        $app->make('Illuminate\Foundation\Bootstrap\LoadConfiguration')->bootstrap($app);
        $timezone = $this->getApplicationTimezone($app);

        ! is_null($timezone) && date_default_timezone_set($timezone);

        $aliases   = array_merge($this->getApplicationAliases($app), $this->getPackageAliases($app));
        $providers = array_merge($this->getApplicationProviders($app), $this->getPackageProviders($app));

        $app['config']->set('theme.paths', $this->paths);
        $app['config']->set('theme.activate', $this->activate);

        $app['config']['app.aliases']   = $aliases;
        $app['config']['app.providers'] = $providers;
    }

    /**
     * Load package service provider.
     *
     * @param  \Illuminate\Foundation\Application $app
     * @return array
     */
    protected function getPackageProviders($app)
    {
        return [ThemeServiceProvider::class];
    }

    /**
     * Load package alias.
     *
     * @param  \Illuminate\Foundation\Application $app
     * @return array
     */
    protected function getPackageAliases($app)
    {
        return [
            //'Theme' => ThemeFacade::class,
        ];
    }
}