<?php
namespace Ignite\Theme\Tests;

use Ignite\Theme\Theme;

class ThemeTest extends TestCase
{
    /**
     * @test
     */
    public function it_can_create_a_theme_instance_without_a_parent()
    {
        $theme = new Theme('test', '/fake/path', 'The test theme', null);
        $this->assertSame('test', $theme->name());
        $this->assertSame('/fake/path', $theme->path());
        $this->assertSame('The test theme', $theme->description());
        $this->assertSame(null, $theme->parent());
        $this->assertFalse($theme->isChild());
    }

    /**
     * @test
     */
    public function it_can_create_a_theme_instance_with_a_parent()
    {
        $theme = new Theme('test', '/fake/path', 'The test theme', 'parent');
        $this->assertSame('parent', $theme->parent());
        $this->assertTrue($theme->isChild());
    }

    /**
     * @test
     */
    public function it_can_determine_the_asset_path_from_the_theme_name()
    {
        $theme = new Theme('TeSt', '/fake/path', 'The test theme', null);

        $this->assertSame('test', $theme->assetPath());
    }

    /**
     * @test
     */
    public function it_can_cast_a_theme_instance_to_array()
    {
        $theme = new Theme('test', '/fake/path', 'The test theme', null);

        $this->assertInternalType('array', $theme->toArray());
        $this->assertSame([
            'name' => 'test',
            'path' => '/fake/path',
            'description' => 'The test theme',
            'parent' => null
        ], $theme->toArray());
    }
}
