<?php

namespace Ignite\Theme\Tests;

use Ignite\Theme\Asset;
use Ignite\Theme\Factory;
use Ignite\Theme\Manager;
use Ignite\Theme\Theme;
use Ignite\Theme\UrlGenerator;

class AssetTest extends TestCase
{
    /** @var Asset */
    protected $asset;

    public function setUp()
    {
        parent::setUp();

        $this->asset = new Asset($this->app->make(Manager::class), $this->app->make(UrlGenerator::class));
    }

    /**
     * @test
     */
    public function it_can_create_a_manager_instance()
    {
        $this->assertInstanceOf(Asset::class, $this->asset);
    }

    /**
     * @test
     */
    public function it_can_generate_a_url_to_the_stylesheets_folder()
    {
        $style = $this->asset->style();

        $this->assertEquals(asset('themes/parent/stylesheets'), $style);
    }

    /**
     * @test
     */
    public function it_can_generate_a_url_to_a_stylesheet_file()
    {
        $style = $this->asset->style('/style.css');

        $this->assertEquals(asset('themes/parent/stylesheets/style.css'), $style);
    }

    /**
     * @test
     */
    public function it_can_generate_a_url_to_the_javascripts_folder()
    {
        $script = $this->asset->script();

        $this->assertEquals(asset('themes/parent/javascripts'), $script);
    }

    /**
     * @test
     */
    public function it_can_generate_a_url_to_a_javascript_file()
    {
        $style = $this->asset->script('/script.css');

        $this->assertEquals(asset('themes/parent/javascripts/script.css'), $style);
    }

    /**
     * @test
     */
    public function it_can_generate_a_url_to_the_images_folder()
    {
        $script = $this->asset->image();

        $this->assertEquals(asset('themes/parent/images'), $script);
    }

    /**
     * @test
     */
    public function it_can_generate_a_url_to_a_image_file()
    {
        $style = $this->asset->image('/logo.png');

        $this->assertEquals(asset('themes/parent/images/logo.png'), $style);
    }

    /**
     * @test
     */
    public function it_can_generate_a_url_to_the_fonts_folder()
    {
        $script = $this->asset->font();

        $this->assertEquals(asset('themes/parent/fonts'), $script);
    }

    /**
     * @test
     */
    public function it_can_generate_a_url_to_a_font_file()
    {
        $style = $this->asset->font('fontawesome-webfont.ttf');

        $this->assertEquals(asset('themes/parent/fonts/fontawesome-webfont.ttf'), $style);
    }

    /**
     * @test
     */
    public function it_can_be_extended_using_macros()
    {
        Asset::macro('svg', function ($path = null) {
            return $this->directoryOrFile('svg', $path);
        });

        $svgs = $this->asset->svg();
        $svg = $this->asset->svg('icon.svg');

        $this->assertEquals(asset('themes/parent/svg'), $svgs);
        $this->assertEquals(asset('themes/parent/svg/icon.svg'), $svg);
    }
}
