<?php

namespace Ignite\Theme;

use Illuminate\Support\Traits\Macroable;

class Asset
{
    use Macroable;

    /**
     * @var Manager
     */
    private $manager;

    /**
     * @var UrlGenerator
     */
    private $url;

    /**
     * Asset constructor.
     *
     * @param Manager $manager
     * @param UrlGenerator $url
     */
    public function __construct(Manager $manager, UrlGenerator $url)
    {
        $this->manager = $manager;
        $this->url = $url;
    }

    /**
     * The url to the current theme's stylesheets folder or a file within.
     *
     * @param  string|null $path
     * @param  bool $secure
     * @return string
     */
    public function style($path = null, $secure = false)
    {
        return $this->directoryOrFile('stylesheets', $path, $secure);
    }

    /**
     * The url to the current theme's javascripts folder or a file within.
     *
     * @param  string $path
     * @param  bool $secure
     * @return string
     */
    public function script($path = null, $secure = false)
    {
        return $this->directoryOrFile('javascripts', $path, $secure);
    }

    /**
     * The url to the current theme's images folder or a file within.
     *
     * @param  string $path
     * @param  bool $secure
     * @return string
     */
    public function image($path = null, $secure = false)
    {
        return $this->directoryOrFile('images', $path, $secure);
    }

    /**
     * The url to the current theme's fonts folder or a file within.
     *
     * @param  string $path
     * @param  bool $secure
     * @return string
     */
    public function font($path = null, $secure = false)
    {
        return $this->directoryOrFile('fonts', $path, $secure);
    }

    /**
     * The url to a directory under the current theme.
     *
     * @param  string $name
     * @param  bool $secure
     * @return string
     */
    protected function directory($name, $secure = false)
    {
        return $this->url->asset($name, $secure);
    }

    /**
     * The url to a directory under the current theme or a file within.
     *
     * @param  string $name
     * @param  string|null $path
     * @param  bool $secure
     * @return string
     */
    protected function directoryOrFile($name, $path = null, $secure = false)
    {
        $url = $this->directory($name, $secure);

        if (empty($path)) {
            return $url;
        }

        return $url . '/' . ltrim($path, '/');
    }
}
