<?php

namespace Ignite\Theme\Tests\Console;

use Ignite\Theme\Tests\TestCase;
use Illuminate\Support\Facades\Event;
use org\bovigo\vfs\vfsStream;

class ScaffoldCommandTest extends TestCase
{
    /**
     * @var \org\bovigo\vfs\vfsStreamDirectory
     */
    protected $root;

    public function setUp()
    {
        parent::setUp();

        $this->root = vfsStream::setup('root', null, ['themes' => []]);

        vfsStream::copyFromFileSystem(__DIR__ . '/../stubs/', $this->root);
        $this->app->setBasePath($this->root->url());

        $this->app['config']->set('theme.paths', [
            vfsStream::url('root/parent'),
            vfsStream::url('root/child')
        ]);
    }

    /**
     * @test
     */
    public function it_scaffolds_a_new_theme_file_and_directory_structure()
    {
        $command = $this->artisan('ignite:theme:scaffold', [
            'name' => 'test'
        ]);

        $closure = \Closure::fromCallable([$this, 'it_tests_the_event_payload']);

        Event::shouldReceive('fire')->once()->with('ignite.theme.scaffolding', \Mockery::on($closure));
        Event::shouldReceive('fire')->once()->with('ignite.theme.scaffolded', \Mockery::on($closure));

        $command->expectsOutput('✓ Theme `test` scaffold complete.');

        $command->run();
        $this->assertDirectoryExists(base_path('themes/test'));
        $this->assertDirectoryExists(base_path('themes/test/dist'));
        $this->assertDirectoryExists(base_path('themes/test/views'));
        $this->assertDirectoryExists(base_path('themes/test/src'));
        $this->assertFileExists(base_path('themes/test/theme.json'));
        $this->assertJsonStringEqualsJsonFile(base_path('themes/test/theme.json'), '{"name":"test"}');
    }

    public function it_tests_the_event_payload($payload)
    {
        $this->assertInternalType('array', $payload);
        $this->assertArrayHasKey('input', $payload);
        $this->assertArrayHasKey('output', $payload);
        $this->assertInstanceOf(\Symfony\Component\Console\Input\InputInterface::class, $payload['input']);
        $this->assertInstanceOf(\Symfony\Component\Console\Output\OutputInterface::class, $payload['output']);
        return true;
    }
}
