@extends('layouts.site')
@section('meta_title', 'Edit Profile')
@section('content_header')
    @include('partials._components._heading', ['heading' => 'Edit Profile'])
@endsection
@section('content')
    <section class="container participant-profile-edit">
        <div class="row">
            <div class="col-md-4">
                @include('partials._components._user-menu')
            </div>
            <div class="col-md-8">
                <div class="panel panel-default mt-4 mb-4">
                    <div class="panel-heading">
                        <div class="clearfix">
                            <strong class="panel-title pull-left fullname" style="padding-top: 4px; text-shadow: 1px 1px 0 #fff;">{{ auth()->user()->fullName() }}</strong>
                            <div class="btn-group pull-right">
                                <a href="{{ route('participant.profile.show') }}" class="btn btn-sm btn-default view-profile-button"><span class="fa-solid fa-user-circle"></span> View Profile</a>
                                <a href="{{ route('participant.password.edit') }}" class="btn btn-sm btn-default change-password-button"><span class="fa-solid fa-key"></span> Change Password</a>
                            </div>
                        </div>
                    </div>
                    <div class="panel-body">
                        @yield('content-main')
                        {!! form($form) !!}
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('js')
    @parent
    @include('partials._participant.conditionals')
    <script type="text/javascript">
        jQuery(function($) {
            var icons = {
                time: "fa-solid fa-clock",
                date: "fa-solid fa-calendar",
                up: "fa-solid fa-arrow-up",
                down: "fa-solid fa-arrow-down",
                previous: 'fa-solid fa-chevron-left',
                next: 'fa-solid fa-chevron-right',
                today: 'fa-solid fa-calendar-times',
                clear: 'fa-solid fa-trash',
                close: 'fa-solid fa-remove'
            };
        });

        var $datetimepickers = $('.datetimepicker');
        $datetimepickers.length && $datetimepickers.datetimepicker({
            format: 'MM/DD/YYYY HH:mm:ss',
            icons: icons
        });

        var $datepickers = $('.datepicker');
        $datepickers.length && $datepickers.datetimepicker({
            format: 'MM/DD/YYYY',
            icons: icons
        });
    </script>
@endsection
