@extends('layouts.site')

@section('meta_title', __('Claim::claim.create.title'))

@section('content_header')
    @include('partials._components._heading', [
        'heading' => __('Claim::claim.create.title')
    ])
@endsection

@section('content')

    <section class="container">
        <div class="mt-4 mb-4">
            @include('partials._claim.form')
            @include('partials._claim._dialog._items')
            @include('partials._claim._dialog._participant')
        </div>
    </section>

@endsection

@section('js')
    @parent
    <script>
        var offerGroups = {!! json_encode($offerGroups, JSON_PRETTY_PRINT) !!};
        var dirtyFlag = false;
        window.validationConfig = {
            errorElement: 'em',
            errorPlacement: function (error, element) {
                error.addClass('help-block');
                element.parents('.form-group').addClass('has-feedback');

                if (element.prop('type') === 'checkbox') {
                    error.insertAfter(element.parent('label'));
                } else {
                    error.insertAfter(element);
                }
                /*if (! element.parent().next('span')[0]) {
                    $("<span class='fa-solid fa-remove form-control-feedback'></span>").appendTo(element.parents('.form-group'));
                }*/
            },
            success: function (label, element) {
                /*var $element = $(element);
                if (! $element.parent().next('span')[0]) {
                    $("<span class='fa-solid fa-check text-success form-control-feedback'></span>").appendTo($element.parents('.form-group'));
                }*/
            },
            highlight: function (element, errorClass, validClass) {
                var $element = $(element);
                $element.parents('.form-group').addClass('has-error').removeClass('has-success');
            },
            unhighlight: function (element, errorClass, validClass) {
                var $element = $(element);
                $element.parents('.form-group').removeClass('has-success').removeClass('has-error');
            }
        };
    </script>
    <script src="{{ asset('/vendor/ignite/js/claim/newClaim.js') }}"></script>
    <script src="{{ asset('/vendor/ignite/js/claim/newClaimItem.js') }}"></script>
    <script src="{{ asset('/vendor/ignite/js/claim/newClaimParticipant.js') }}"></script>
@endsection
