@extends('layouts.site')

@section('meta_title', $catalog->name)

@section('content')
    @include('partials._catalog.toolbar.toolbar')
    <section class="container mt-2">
        @include('partials._catalog.toolbar.breadcrumbs')
        <div class="row">
            <div class="col-xs-12 col-md-9 pull-right catalog-list">
                <div class="panel panel-transparent catalog-list-container">
                    <div class="panel-body p-0">
                        @if ($items->isNotEmpty())
                            <div class="row">
                                @foreach ($items as $item)
                                    <div class="col-xs-6 col-sm-4 col-md-4">
                                        @include('partials._catalog.item', $item)
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <div class="col-sm-6 col-sm-offset-3 text-center">
                                <div class="text-center mt-4 mb-4">
                                    <span class="fa-solid fa-shopping-basket fa-5x text-muted muted"></span>
                                    <h4 class="muted text-center">
                                    @if (request()->has('keyword'))
                                        {!! __('Catalog::theme.sidebar.search.no_results_for_keyword', ['keyword' => request()->get('keyword')]) !!}
                                    @else
                                        {{ __('Catalog::theme.sidebar.search.no_results') }}
                                    @endif
                                    </h4>
                                </div>
                                @if (request()->has('keyword'))
                                    <a href="{{ route('catalog.show', $catalog->code) }}" class="btn btn-default">{{ __('Catalog::theme.sidebar.search.reset') }}</a>
                                @else
                                    <a href="{{ route('catalog.index') }}" class="btn btn-default">{{ __('Catalog::theme.sidebar.search.back') }}</a>
                                @endif
                            </div>
                        @endif
                    </div>
                </div>
                {{ $items->appends(request()->input()) }}
            </div>
            <div class="col-md-3 pull-left catalog-filters" id="catalog-filters">
                @include('partials._catalog.sidebar')
            </div>
        </div>
    </section>
@endsection

@section('js')
    @parent
    <script src="{{ asset('/vendor/ignite/js/catalog/catalog.js') }}"></script>
@endsection
