@extends('layouts.site')

@section('meta_title', $item->name . ' | ' . $item->catalog->name)

@php
    $minRequiredAmount = $threshold->getMinRequiredAmount();
    $minRequiredAmountPoints = $threshold->convertDollarToPointsWithMarkup($minRequiredAmount);
    $minRequiredAmountTxt = '$' . $minRequiredAmount
        . ($minRequiredAmount <> $minRequiredAmountPoints
        ? ' (' . number_format($minRequiredAmountPoints, 0) . ' points)' : '');

    $minRequiredAmountAfterFirst = $threshold->getMinAmountAfterFirstOrder();
    $minRequiredAmountAfterFirstPoints = $threshold->convertDollarToPointsWithMarkup($minRequiredAmountAfterFirst);
    $minRequiredAmountAfterFirstTxt = '$' . $minRequiredAmountAfterFirst
        . ($minRequiredAmountAfterFirst <> $minRequiredAmountAfterFirstPoints
        ? ' (' . number_format($minRequiredAmountAfterFirstPoints, 0) . ' points)' : '');
@endphp

@section('content')
    <section class="container mt-2">
        @include('catalog.reloadable._partials.toolbar')
        <div class="row">
            <div class="col-xs-12">
                <div class="panel-stack-shadow">
                    <div class="panel panel-squared mb-4">
                        <div class="panel-body">
                            <div class="row">
                                <div id="card-info" class="col-xs-12 col-md-{{ $threshold->hasCreatedReloadableCard() ? '8' : '6' }}">
                                    @section('card-info-title')
                                    <div class="mb-2">
                                        <h3 class="m-0">{{ $item->name }}</h3>
                                        <hr />
                                    </div>
                                    @show
                                    @section('card-info-image')
                                        <div class="item__image-container mt-2 mb-2">
                                            <img class="item__image--rounded img-responsive" src="{{ $item->getImageUrl()  }}">
                                        </div>
                                    @show
                                    @section('card-info-description')
                                        @php
                                        // we replace X points|dollars in the description with the minimum
                                        // required amount depending on the user
                                        $description = preg_replace('/\$([0-9]+)/', '\$' . $minRequiredAmount, $item->description);
                                        $description = preg_replace('/([0-9]+)\s(points|dollars)/', '\$' . $minRequiredAmount, $description);
                                        @endphp
                                        <div class="lead">
                                            {!! $description !!}
                                        </div>
                                    @show
                                    @section('card-info-terms')
                                        @if ('' !== trim($item->terms))
                                            <div class="panel-group p-0 m-0" id="accordion" role="tablist" aria-multiselectable="true">
                                                <div class="panel panel-transparent p-0 m-0">
                                                    <div class="panel-heading" role="tab" id="headingOne">
                                                        <h4 class="panel-title">
                                                            <a href="#item-terms" class="collapsible" role="button" data-toggle="collapse" data-parent="#accordion" aria-expanded="false" aria-controls="collapseOne">
                                                                <span class="fa-solid fa-chevron-down"></span> Terms of Use
                                                            </a>
                                                        </h4>
                                                    </div>
                                                    <div id="item-terms" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingOne">
                                                        <div class="panel-body">
                                                            <div class="text-block">{!! $item->terms !!}</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    @show
                                </div>
                                <div id="card-form" class="col-xs-12 col-md-{{ $threshold->hasCreatedReloadableCard() ? '4' : '6' }}">
                                    @section('warning-note')
                                        @if ($threshold->isFirstOrder() && $minRequiredAmount > 1)
                                            <div class="alert alert-warning mb-2">
                                                <p class="m-0 text-left"><span class="fa-solid fa-exclamation-circle"></span> Important</p>
                                                <p class="mt-1 text-left text-normal" style="font-weight: 400">
                                                    It looks like you haven't ordered this card before.
                                                    You'll need to load at least {{ $minRequiredAmountTxt }} onto the card for your first transaction.
                                                    @if ($minRequiredAmountAfterFirst <= 1)
                                                        Future redemptions made after this can occur at any dollar value.
                                                    @elseif ($minRequiredAmountAfterFirst <> $minRequiredAmount)
                                                        Future redemptions made after this must be at least {{ $minRequiredAmountAfterFirstTxt }}.
                                                    @endif
                                                </p>
                                            </div>
                                        @elseif ($minRequiredAmount > 1)
                                            <div class="alert alert-warning mb-2">
                                                <p class="m-0 text-left"><span class="fa-solid fa-exclamation-circle"></span> Important</p>
                                                <p class="mt-1 text-left text-normal" style="font-weight: 400">
                                                    You will need to load at least {{ $minRequiredAmountTxt }} onto the card.
                                                </p>
                                            </div>
                                        @endif
                                    @show
                                    @section('js-errors')
                                        <div class="js-errors alert alert-danger mb-3"></div>
                                    @show
                                    @include('catalog.reloadable._partials.form')
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('js')
    @parent
    <script type="text/javascript">
    jQuery(document).ready(function($) {
        $('div.js-errors').hide();
    });
    </script>
@endsection
