@extends('layouts.site')

@section('meta_title', __('Catalog::theme.favorite.heading'))

@section('content')
    @include('partials._catalog.toolbar.toolbar')
    <section class="container mt-2">
        @include('partials._catalog.toolbar.breadcrumbs', [
            'crumbs' => [
                ['url' => '', 'title' => __('Catalog::theme.favorite.heading')]
            ],
            'noCatalog' => true
        ])
        <div class="row">
            <div class="col-xs-12 catalog-list">
                <div class="panel panel-transparent catalog-list-container">
                    <div class="panel-body p-0">
                        @if ($items->isNotEmpty())
                        <div class="row">
                            @foreach ($items as $item)
                                <div class="col-xs-6 col-sm-4 col-md-3">
                                    @include('partials._catalog.item', ['item' => $item])
                                </div>
                            @endforeach
                        </div>
                        @else
                            <div class="col-sm-6 col-sm-offset-3 text-center">
                                <div class="text-center mt-4 mb-4">
                                    <span class="fa-solid fa-heart fa-5x text-muted muted"></span>
                                    <h4 class="muted text-center">{{ __('Catalog::theme.favorite.empty') }}</h4>
                                </div>
                                <a href="{{ route('catalog.index') }}" class="btn btn-default">{{ __('Catalog::theme.cart.continue') }}</a>
                            </div>
                        @endif
                    </div>
                </div>
                {{ $items->links() }}
            </div>
        </div>
    </section>
@endsection

@section('js')
    @parent
    <script src="{{ asset('/vendor/ignite/js/catalog/catalog.js') }}"></script>
@endsection
