const mix = require('laravel-mix');
const FileCollection = require('laravel-mix/src/FileCollection');

// if you change realPublicPath to '../../public/themes/your-theme-name/',
// then you can publish directly to public folder (or npm watch)
// and not need to run php artisan ignite:theme:publish each time.
const realPublicPath = '';

mix.setPublicPath('dist/');

// mix.js() is added to .babel() just so the 'npm run watch' can invoke
//   mix.version() and .then() for javascript changes.
mix.js('src/js/script.js', 'javascripts/scripts.js')
.babel([
    'node_modules/moment/moment.js',
    //'node_modules/moment-timezone/moment-timezone.js',
    'node_modules/jquery/dist/jquery.js',
    //'node_modules/popper.js/dist/popper.js',
    'node_modules/bootstrap-sass/assets/javascripts/bootstrap.js',
    'node_modules/bootstrap-datepicker/dist/js/bootstrap-datepicker.js',
    'node_modules/jquery-match-height/dist/jquery.matchHeight.js',
    'node_modules/jquery-circle-progress/dist/circle-progress.js',
    'node_modules/jquery-validation/dist/jquery.validate.js',
    'node_modules/select2/dist/js/select2.full.js',
    '../../vendor/ignite/modules/Core/resources/assets/js/ignite.js',
    'src/js/script.js'
], 'dist/javascripts/scripts.js');

mix.sass('src/scss/style.scss', 'stylesheets/styles.css', {
    sassOptions: {
        includePaths: [
            './src/scss',
            '../../vendor/ignite/themes/default/src/scss',
            './node_modules/bootstrap-sass/assets/stylesheets'
        ]
    }
}).options({
    processCssUrls: false
});

mix.version()
.then(() => {
    // now copy dist/ to real public path
    if (realPublicPath) {
        let files = new FileCollection('dist/');
        files.copyTo(new File(realPublicPath));
    }
});