@foreach ($pages as $page)
    @if ($page->canBeViewed())
        @if ($page->hasChildren())
            <li class="page-nav-item page-nav-item--has-dropdown dropdown">
                <a class="dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" href="{{ $page->getUrl() }}">{{ $page->getLabel() }} <span class="caret"></span></a>
                <ul class="dropdown-menu page-nav-dropdown">
                @foreach ($page->getChildren() as $child)
                    @if ($child->canBeViewed())
                    <li><a href="{{ $child->getUrl() }}">{{ $child->getLabel() }}</a></li>
                    @endif
                @endforeach
                </ul>
            </li>
        @else
            <li class="page-nav-item{{ request()->fullUrlIs($page->getUrl()) ? ' page-nav-item--active' : '' }}"><a href="{{ $page->getUrl() }}">{{ $page->getLabel() }}</a></li>
        @endif
    @endif
@endforeach
