@php
    $trackingUA = config('core.google.analytics.tracking');
    $trackingGA4 = config('core.google.analytics.tracking_ga4', config('core.google.analytics.tracking_g4'));
    $tracking = ! empty($trackingUA) ? $trackingUA : $trackingGA4;
@endphp

@env('local')
@if (! empty($tracking))
<!-- local: gtag('config', '{{ $trackingUA }}') -->
<!-- local: gtag('config', '{{ $trackingGA4 }}') -->
@endif
@endenv

@production
@if (! empty($tracking))
<script async src="https://www.googletagmanager.com/gtag/js?id={{ $tracking }}"></script>
<script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());
@if (! empty($trackingUA))
    gtag('config', '{{ $trackingUA }}');
@endif
@if (! empty($trackingGA4))
    gtag('config', '{{ $trackingGA4 }}');
@endif
</script>
@endif
@endproduction
