<form novalidate id="checkout" name="checkout" method="post" action="{{ route('catalog.checkout.store') }}">
    {{ csrf_field() }}
    <div class="form-group">
        <div class="row">
            <div class="col-sm-4 form-input {{ $errors->has('first') ? 'is-invalid has-error' : '' }}">
                <label for="first" class="control-label">{{ __('Catalog::theme.checkout.form.first_name.label') }}</label>
                <input type="text" class="form-control" id="first" name="first" value="{{ old('first', $participant->first) }}" maxLength="50" required />
                @if ($errors->has('first'))
                <span class="help-block">{{ $errors->first('first') }}</span>
                @endif
            </div>
            <div class="col-sm-4 form-input {{ $errors->has('last') ? 'is-invalid has-error' : '' }}">
                <label for="last" class="control-label">{{ __('Catalog::theme.checkout.form.last_name.label') }}</label>
                <input type="text" class="form-control" id="last" name="last" value="{{ old('last', $participant->last) }}" maxLength="50" required />
                @if ($errors->has('last'))
                    <span class="help-block">{{ $errors->first('last') }}</span>
                @endif
            </div>
            <div class="col-sm-4 form-input {{ $errors->has('ship_phone') ? 'is-invalid has-error' : '' }}">
                <label for="ship_phone" class="control-label">{{ __('Catalog::theme.checkout.form.phone_number.label') }}</label>
                <input type="text" class="form-control" id="ship_phone" name="ship_phone" value="{{ old('ship_phone', $participant->phone1) }}" maxLength="20" required />
                @if ($errors->has('ship_phone'))
                    <span class="help-block">{{ $errors->first('ship_phone') }}</span>
                @endif
            </div>
        </div>
    </div>
    @if ($cart->hasNonPhysical())
        <hr class="clearfix" />
        <div class="form-group">
            <div class="row">
                <div class="col-sm-8 form-input {{ $errors->has('ship_email') ? 'is-invalid has-error' : '' }}">
                    <label for="email" class="control-label">{{ __('Catalog::theme.checkout.form.email.label') }}</label>
                    <input type="email" class="form-control email" id="email" name="ship_email" value="{{ old('ship_email', $participant->email) }}" maxLength="255" required />
                    @if ($errors->has('ship_email'))
                        <span class="help-block">{{ $errors->first('ship_email') }}</span>
                    @endif
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <span class="help-block mb-0">
                        <em class="text-info">{{ __('Catalog::theme.checkout.form.email.help.card') }} {{ str_plural('card', $cart->countNonPhysical()) }}</em>.
                    </span>
                </div>
            </div>
        </div>
        <hr class="clearfix" />
    @endif
    @if ($cart->hasPhysical())
    <div class="form-group">
        <label for="ship_address_1" class="control-label">{{ __('Catalog::theme.checkout.form.address.label') }}</label>
        <div class="row">
            <div class="col-sm-12 form-input {{ $errors->has('ship_address_1') ? 'is-invalid has-error' : '' }}">
                <input placeholder="{{ __('Catalog::theme.checkout.form.address1.label') }}" type="text" class="form-control" id="ship_address_1" name="ship_address_1" value="{{ old('ship_address_1', $participant->address_1) }}" maxLength="100" required />
            </div>
        </div>
        <div class="row mt-1">
            <div class="col-sm-6 form-input {{ $errors->has('ship_address_2') ? 'is-invalid has-error' : '' }}">
                <input placeholder="{{ __('Catalog::theme.checkout.form.address2.label') }}" type="text" class="form-control" id="ship_address_2" name="ship_address_2" value="{{ old('ship_address_2', $participant->address_2) }}" maxLength="100" />
            </div>
            <div class="col-sm-6 form-input {{ $errors->has('ship_address_3') ? 'is-invalid has-error' : '' }}">
                <input placeholder="{{ __('Catalog::theme.checkout.form.address3.label') }}" type="text" class="form-control" id="ship_address_3" name="ship_address_3" value="{{ old('ship_address_3', '') }}" maxLength="100" />
            </div>
        </div>
        @if ($errors->has('ship_address_1') || $errors->has('ship_address_2') || $errors->has('ship_address_3'))
        <div class="row mt-1">
            <div class="col-sm-12 form-input is-invalid has-error">
                <div class="help-block">{{ $errors->first('ship_address_1') }}</div>
                <div class="help-block">{{ $errors->first('ship_address_2') }}</div>
                <div class="help-block">{{ $errors->first('ship_address_3') }}</div>
            </div>
        </div>
        @endif
    </div>
    <div class="form-group">
        <div class="row">
            <div class="col-sm-6 form-input {{ $errors->has('ship_city') ? 'is-invalid has-error' : '' }}">
                <label for="ship_city" class="control-label">{{ __('Catalog::theme.checkout.form.city.label') }}</label>
                <input type="text" class="form-control" id="ship_city" name="ship_city" value="{{ old('ship_city', $participant->city) }}" maxLength="100" required />
                @if ($errors->has('ship_city'))
                    <span class="help-block">{{ $errors->first('ship_city') }}</span>
                @endif
            </div>
            <div class="col-sm-6 form-input {{ $errors->has('ship_state') ? 'is-invalid has-error' : '' }}">
                <label for="ship_state" class="control-label">{{ __('Catalog::theme.checkout.form.state.label') }}</label>
                <select name="ship_state" required class="form-control" id="ship_state">
                    @foreach ($states as $key => $value)
                        <option {{ $key == old('ship_state', $participant->state) ? 'selected' : '' }} value="{{ $key}}">{{ $value }}</option>
                    @endforeach
                </select>
                @if ($errors->has('ship_state'))
                    <span class="help-block">{{ $errors->first('ship_state') }}</span>
                @endif
            </div>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <div class="col-sm-6 form-input {{ $errors->has('ship_postal') ? 'is-invalid has-error' : '' }}">
                <label for="ship_postal" class="control-label">{{ __('Catalog::theme.checkout.form.postal.label') }}</label>
                <input type="text" class="form-control" id="ship_postal" name="ship_postal" value="{{ old('ship_postal', $participant->postal) }}" required />
                @if ($errors->has('ship_postal'))
                    <span class="help-block">{{ $errors->first('ship_postal') }}</span>
                @endif
            </div>
            <div class="col-sm-6 form-input {{ $errors->has('ship_country') ? 'is-invalid has-error' : '' }}">
                <label for="ship_country" class="control-label">{{ __('Catalog::theme.checkout.form.country.label') }}</label>
                <select name="ship_country" required class="form-control" id="ship_country">
                    @foreach ($countries as $key => $value)
                        <option {{ $key == old('ship_country', $participant->country) ? 'selected' : '' }} value="{{ $key}}">{{ $value }}</option>
                    @endforeach
                </select>
                @if ($errors->has('ship_country'))
                    <span class="help-block">{{ $errors->first('ship_country') }}</span>
                @endif
            </div>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <div class="col-sm-12 form-input">
                <label>
                    <input type="checkbox" id="business" name="business" value="1"{{ !empty(old('business', '')) ? ' checked="checked"' : '' }} />
                    {{ __('Catalog::theme.checkout.form.is_business_address.label') }}
                </label>
            </div>
        </div>
    </div>
    <hr class="clearfix" />
    @endif
    {{--<div class="form-group">
        <label for="ship_country" class="col-sm-4 control-label">Country Code (ie: US)</label>
        <div class="col-sm-6">
            <input type="text" class="form-control" id="ship_country" name="ship_country" value="{{ $order['ship_country'] ?? Auth::user()->participant->country ?? 'US' }}" maxLength="5" required />
        </div>
    </div>--}}
    <div class="form-group m-0">
        <a href="{{ route('catalog.index') }}" class="btn btn-default pull-left">{{ __('Catalog::theme.checkout.form.back.label') }}</a>
        <button type="submit" class="btn btn-success pull-right">{{ __('Catalog::theme.checkout.form.submit.label') }}</button>
    </div>
</form>
