<table class="table table-responsive" id="cartItemsTable">
    <thead>
    <tr>
        <th class="hidden-xs" width="200">&nbsp;</th>
        <th class="text-muted"><span class="hidden-xs">{{ __('Catalog::theme.cart.table.item') }}</span> {{ __('Catalog::theme.cart.table.name') }}</th>
        <th class="text-muted text-right"><span class="visible-xs">{{ __('Catalog::theme.cart.table.qty') }}</span><span class="hidden-xs">{{ __('Catalog::theme.cart.table.quantity') }}</span></th>
        <th class="text-muted text-right">{{ __('Catalog::theme.cart.table.points') }}</th>
        <th>&nbsp;</th>
    </tr>
    </thead>
    <tbody>
    @if ($cart->notEmpty())
        @foreach($cart->items() as $item)
            @include('partials._catalog.cart.item', [
                'item' => $item
            ])
        @endforeach
        <tr>
            <td class="hidden-xs">&nbsp;</td>
            <td>&nbsp;</td>
            <td class="text-right"><strong>{{ __('Catalog::theme.cart.table.total') }}:</strong></td>
            <td class="text-right"><strong>{{ $cart->total() }}</strong></td>
            <td>&nbsp;</td>
        </tr>
        <tr>
            <td class="hidden-xs">&nbsp;</td>
            <td>&nbsp;</td>
            <td class="text-right">{{ __('Catalog::theme.cart.table.available') }}:</td>
            <td class="text-right">{{ $cart->balance() }}</td>
            <td>&nbsp;</td>
        </tr>
        <tr>
            <td class="hidden-xs">&nbsp;</td>
            <td>&nbsp;</td>
            <td class="text-right">{{ __('Catalog::theme.cart.table.after') }}:</td>
            <td class="text-right">
                @if ($cart->canCheckout())
                    {{ $cart->deficit() }}
                @else
                    <span class="text-danger">{{ $cart->deficit() }}</span>
                @endif
            </td>
            <td>&nbsp;</td>
        </tr>
    @else
        <tr>
            <td colspan="6" class="text-danger text-center">{{ __('Catalog::theme.cart.empty') }}</td>
        </tr>
    @endif
    </tbody>
</table>
