@extends('layouts.site')

@section('meta_title', '404 - Page Not Found')
@section('meta_description', 'Page Not Found')

@section('content')
    <section class="page-content">
        <div class="container content-section">
            <div class="col-sm-6 col-sm-offset-3">
                <div class="panel panel-default">
                    <div class="panel-body mb-0">
                        <h3 class="mb-2 mt-0">Page not found</h3>
                        <p>We're sorry, we couldn't find a page at "{{ request()->getRequestUri() }}". If you followed a link to this page, the page could have been moved or deleted, please consider contacting us via email at <a href="mailto:{{ config('mail.from.address') }}?subject=Page not found: {{ request()->getRequestUri() }}">{{ config('mail.from.address') }}</a> to let us know.</p>
                        <div class="clearfix">
                            <a class="btn btn-default" href="{{ route('homepage') }}"><span class="fa fa-chevron-left"></span> Go to the homepage</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
