@extends('layouts.site')
@section('meta_title', __('Catalog::theme.checkout.complete.heading'))
@section('content')
    @include('partials._catalog.toolbar.toolbar')
    <section class="container">
        <div class="row">
            <div class="col-md-8 col-md-offset-2">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="mt-3 text-center">
                            <h4 class="m-0">{!! __('Catalog::theme.checkout.complete.greeting') !!}</h4>
                            <div class="mt-2 mb-2">
                                <span class="fa fa-check fa-4x text-success"></span>
                            </div>
                            <p class="mb-4">
                                {!! __('Catalog::theme.checkout.complete.message') !!}
                            </p>
                            <h3 class="text-muted mb-4">#{{ $order->number }}</h3>
                        </div>
                    </div>
                </div>
                @if ($order->hasNonPhysical())
                <div class="row">
                    <div class="col-sm-12">
                        <div class="panel-stack-shadow">
                            <div class="panel panel-default panel-squared mb-4">
                                <div class="panel-body">
                                    <span class="fa fa-credit-card text-success"></span>
                                    {!! __('Catalog::theme.checkout.complete.egift.message', ['card' => str_plural('card', $order->countNonPhysical()), 'email' => $order->ship_email]) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endif
                @if ($order->hasPhysical())
                <div class="row">
                    <div class="col-md-6 mt-2">
                        <div class="panel-stack-shadow">
                            <div class="panel panel-default panel-squared mb-4 text-left">
                                <div class="panel-heading text-left">
                                    {{ __('Catalog::theme.checkout.complete.shipping.heading') }}
                                </div>
                                <div class="panel-body text-left">
                                    <p class="clearfix mb-1">
                                        <strong class="pull-left">{{ __('Catalog::theme.checkout.form.name.label') }}:</strong>
                                        <span class="pull-right text-right">{{ $order->ship_name }}</span>
                                    </p>
                                    <p class="clearfix mb-1">
                                        <strong class="pull-left">{{ __('Catalog::theme.checkout.form.address.label') }}:</strong>
                                        <span class="pull-right text-right">
                                            {{ $order->ship_address_1 }}
                                            @if (!empty($order->ship_address_2))
                                                <br/>{{ $order->ship_address_2 }}
                                            @endif
                                            @if (!empty($order->ship_address_3))
                                                <br/>{{ $order->ship_address_3 }}
                                            @endif
                                        </span>
                                    </p>
                                    <p class="clearfix mb-1">
                                        <strong class="pull-left">{{ __('Catalog::theme.checkout.form.city.label') }}:</strong>
                                        <span class="pull-right text-right">{{ $order->ship_city }}</span>
                                    </p>
                                    <p class="clearfix mb-1">
                                        <strong class="pull-left">{{ __('Catalog::theme.checkout.form.state.label') }}:</strong>
                                        <span class="pull-right text-right">{{ $order->ship_state }}</span>
                                    </p>
                                    <p class="clearfix mb-1">
                                        <strong class="pull-left">{{ __('Catalog::theme.checkout.form.postal.label') }}:</strong>
                                        <span class="pull-right text-right">{{ $order->ship_postal }}</span>
                                    </p>
                                    <p class="clearfix mb-1">
                                        <strong class="pull-left">{{ __('Catalog::theme.checkout.form.country.label') }}:</strong>
                                        <span class="pull-right text-right">{{ $order->ship_country }}</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 mt-2">
                        <div class="panel-stack-shadow">
                            <div class="panel panel-default panel-squared mb-4 text-left">
                                <div class="panel-heading text-left">
                                    {{ __('Catalog::theme.checkout.complete.contact.heading') }}
                                </div>
                                <div class="panel-body text-left">
                                    <p class="clearfix" style="margin: 0 0 10px;">
                                        <strong class="pull-left">{{ __('Catalog::theme.checkout.form.email.label') }}:</strong>
                                        <span class="pull-right text-right">{{ $order->ship_email }}</span>
                                    </p>
                                    <p class="clearfix" style="margin: 0 0 10px;">
                                        <strong class="pull-left">{{ __('Catalog::theme.checkout.form.phone_number.label') }}:</strong>
                                        <span class="pull-right text-right">{{ $order->ship_phone }}</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endif
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel-stack-shadow">
                            <div class="panel panel-default panel-squared mb-4 text-left">
                                <div class="panel-heading text-left">
                                    {{ __('Catalog::theme.checkout.items.heading') }}
                                </div>
                                <div class="panel-body text-left">
                                @foreach ($order->items as $item)
                                    <div class="media">
                                        <p class="pull-right">
                                            <strong>{{ Format::amount((float) $item->points * (int) $item->quantity) }}</strong>
                                        </p>
                                        <div class="media-left">
                                            <img class="media-object" width="80" src="{{ $item->item->getImageUrl() }}" alt="{{ $item->name }}" />
                                        </div>
                                        <div class="media-body" style="width: auto !important;">
                                            <h6 class="media-heading">
                                                <strong>{{ $item->name }}</strong>
                                                <p class="m-0 p-0">x{{ $item->quantity }}</p>
                                            </h6>
                                        </div>
                                    </div>
                                @endforeach
                                </div>
                                <div class="panel-footer text-right">
                                    <strong>{{ __('Catalog::theme.checkout.summary.total') }}: {{ Format::amount($order->points) }}</strong>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-sm-offset-3 mb-4 text-center">
                    <a href="{{ route('catalog.index') }}" class="btn btn-default">{{ __('Catalog::theme.cart.continue') }}</a>
                </div>
            </div>
        </div>
    </section>
@endsection
