@extends('layouts.site')

@section('meta_title', __('Catalog::theme.checkout.heading'))

@section('content')
    @include('partials._catalog.toolbar.toolbar')
    <section class="container">
        <div class="row">
            <div class="col-xs-12">
                @include('partials._catalog.toolbar.breadcrumbs', [
                    'crumbs' => [
                        ['url' => '', 'title' => __('Catalog::theme.checkout.heading')]
                    ],
                    'noCatalog' => true
                ])
            </div>
        </div>
        <div class="row">
            <div class="col-md-8">
                <div class="panel-stack-shadow">
                    <div class="panel panel-default panel-squared mb-4">
                        <div class="panel-body">
                            {!! form($form) !!}
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-4">
                @include('partials._catalog.checkout.summary', ['cart' => $cart])
            </div>
        </div>
    </section>
@endsection

@section('js')
    @parent
    <script type="text/javascript" src="{{ Theme::script('conditionals.js') }}"></script>
    <script>
        window.Catalog = window.Catalog || {};
        window.Catalog.Checkout = window.Catalog.Checkout || {};
        window.Catalog.Checkout.states = window.Catalog.Checkout.states || [];
        window.Catalog.Checkout.states.US = @json(app(\Ignite\Core\Models\Options\States::class)->toDropdown());
        window.Catalog.Checkout.states.CA = @json(app(\Ignite\Core\Models\Options\CanadaStates::class)->toDropdown());

        $('#checkout-form').conditionals({
            rules: [
                {
                    name: 'ship_country',
                    triggers: ['ship_country'],
                    fields: [],
                    conditions: [
                        {
                            checks: [
                                {
                                    field: 'ship_country',
                                    op: '=',
                                    value: 'US'
                                }
                            ],
                            show: ['ship_country', 'ship_state'],
                            required: ['ship_country', 'ship_state'],
                            onHandle: function () {
                                this.toggleInputSelectOptions($('#ship_state'), window.Catalog.Checkout.states.US);
                            }
                        },
                        {
                            checks: [
                                {
                                    field: 'ship_country',
                                    op: '=',
                                    value: 'CA'
                                }
                            ],
                            show: ['ship_country', 'ship_state'],
                            required: ['ship_country', 'ship_state'],
                            onHandle: function () {
                                this.toggleInputSelectOptions($('#ship_state'), window.Catalog.Checkout.states.CA);
                            }
                        },
                        {
                            checks: [
                                {
                                    field: 'ship_country',
                                    op: 'notIn',
                                    value: ['CA', 'US']
                                }
                            ],
                            show: ['ship_country', 'ship_state'],
                            required: ['ship_country', 'ship_state'],
                            onHandle: function (condition) {
                                this.toggleSelectOptionsInput($('#ship_state'), '');
                            }
                        }
                    ]
                }
            ]
        });
    </script>
@endsection
