@extends('layouts.site')

@section('content')
    <section class="container-centered">
        <div class="panel mt-5">
            <div class="panel-heading mt-4 mb-0 text-center">
                <span class="fa fa-key fa-4x"></span>
                <h4 class="panel-title mt-2 mb-1">Update Password</h4>
                <p>Please change your password in the form below. Once your password is updated, you will be logged in.</p>
            </div>
            <div class="panel-body">
                <form class="form-classic" id="password_reset" method="post" action="{{ route('password.request') }}">
                    {{ csrf_field() }}
                    <input type="hidden" name="token" value="{{ $token }}">
                    <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                        <label for="email" class="form-label">Email:</label>
                        <input type="email" class="form-control" id="email" name="email" value="{{ $email ?? old('email') }}" autofocus alt="Enter email associated with your account." required/>
                        @if ($errors->has('email'))
                            @if ('This password reset token is invalid.' !== $errors->first('email'))
                                <span class="help-block">
                                <strong>{{ $errors->first('email') }}</strong>
                            </span>
                            @else
                                <div class="alert alert-danger mt-1">
                                    <strong>{{ __('Your password token has expired.') }}</strong>
                                    <div class="mt-1">
                                        <a class="btn btn-default btn-sm" href="/password/reset?email={{ $email ?? old('email') }}">Reset Password Token</a>
                                    </div>
                                </div>
                            @endif
                        @endif
                    </div>
                    <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
                        <label for="password" class="form-label">New Password:</label>
                        <input type="password" class="form-control" id="password" name="password" value="" regExp="^.{8,100}$" alt="The password must be at least 8 characters long." required/>
                        @if ($errors->has('password'))
                            <span class="help-block">
                                <strong>{{ $errors->first('password') }}</strong>
                            </span>
                        @endif
                    </div>
                    <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
                        <label for="password_confirmation" class="form-label">Confirm Password:</label>
                        <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" value="" required/>
                        @if ($errors->has('password_confirmation'))
                            <span class="help-block">
                                <strong>{{ $errors->first('password_confirmation') }}</strong>
                            </span>
                        @endif
                    </div>
                    <div class="form-group text-center">
                        <button id="password-reset-submit" type="submit" class="btn btn-primary" value="change">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </section>

@endsection