# Changelog

## 3.2.7 - 2024-06-05
### Changes
- Updated the text to the `login.blade.php` to be translatable in Core. ([WDS-5561](https://brightspot.atlassian.net/browse/WDS-5561))

### Upgrading

- It is recommended that you update the `ignite/core` to version `3.2.6` to make use of the translation on the login page.
- If you have a replacement for the view `login.blade.php`, check if that needs to be updated
- After that, if your program does NOT use email as the username, then you may want to change the translation to "Username" or something similar for your program.

## 3.2.6 - 2024-04-12

### Changes

- Updated regex validation for First Name, Last Name, and City fields in enrollment form.

### Updating

- You may want to update your `enrollment.json` with the default one in this update, specifically with the regex rules for First Name, Last Name, and City fields.

## 3.2.5 - 2024-03-27

### Changes
- Updated `enrollment.json` form configuration:
    - Changed `empty_value` option from "-- choose --" to "--- select ---" for better consistency with Kris form builder.
    - Added regex validation for `first`, `last`, `city`, `postal`, and `phone` fields, to prevent "spammy" inputs and invalidate them.
- For reloadable cards:
    - Updated `form.blade.php` to include conditional inclusion of country-specific JavaScript validation based on the card's country.
    - Custom validation rules for phone numbers, state/province, and postal/zip codes for US and CA.
    - Label adjustments for Canadian forms (State to Province).
    - Added country field to the `info-fields.blade.php` form, making it read-only and pre-populated based on the card's country.

### Upgrading
- Some of the files updated are (and that you may need to merge into your program):
    - `forms/enrollment.json`
    - `views/catalog/reloadable/_partials/form.blade.php`
    - `views/catalog/reloadable/_partials/info-fields.blade.php`
- You may need to upgrade ignite/catalog to `3.4.8` to use some new methods.

## 3.2.4.3 - 2024-02-27

### Changes
- Added (missing) view blade `views/emails/batched-email-summary.blade.php` for daily transactions batched email.

## 3.2.4.2 - 2024-02-15

### Changes
- Added new `@section('reloadable-form')` to wrap the form content in `form.blade.php`, improving structure and readability.
- Moved JavaScript code related to form validation and behavior from `create.blade.php` to `form.blade.php`, centralizing the script logic related to the reloadable form.
- Adjusted column widths in create.blade.php by adding IDs #card-info and #card-form for better targeting and potentially more precise styling or scripting.

## 3.2.4.1 - 2024-02-11

### Changes
- In `form.blade.php`, the content of a span element were changed from `amount-dollars` to `amount-points` to correctly represent what is being displaying.
- In `create.blade.php`, refactoring was done to:
    - Correctly replaced `$X` in the item description, as well as `X points|dollars`.
    - Introduced `@section` directives for various parts (`title`, `image`, `description`, and `terms of use`), allowing for more flexible customization.
    - Moved the terms section closer to the card info.
- In `_states.blade.php`, the placeholder text in the state selection dropdown was standardized for consistency.

## 3.2.4 - 2023-12-18

### Changes
- Update the reloadable card pages with better format and messaging, especially for points threshold with markup considered.
    - Blade files`views/catalog/reloadable/_partials/form.blade.php` and  `views/catalog/reloadable/create.blade.php` updated.
- Add phone validation to `enrollment.json`

### Upgrading
- If using Ignite Catalog module, you may need to upgrade to version `3.4.5` to use some new methods.

## 3.2.3 - 2023-10-01

### Changes
- Updated the default `forms\enrollment.json`.

## 3.2.2 - 2023-08-18

### Changes
- Update some catalog view blades to accommodate for TTL. Some are for reloadable card views. ([WDS-3932](https://brightspot.atlassian.net/browse/WDS-3932))

### Upgrading
- If using Catalog module, you may need to upgrade to version `3.4.2` for some new methods.
- If you have a replacement for `views/catalog/order/index.blade.php`, `views/catalog/reloadable/_partials/form.blade.php`, or `views/catalog/reloadable/create.blade.php` in your program, you may need to merge in the changes.

## 3.2.1 - 2023-07-03

### Changes
- Updated `views/partials/_catalog/cart/item.blade.php` to not allow changing the quantity after it is in the cart for certain item. This is needed for Tango for now, since their API can only order one at a time.

### Upgrading
- If using Catalog module, you may need to upgrade to version 3.3.1 to make sure Catalog\Entities\CartItem::canModifyQuantity() exists.
- If you have a replacement for `views/partials/_catalog/cart/item.blade.php` in your program, you may need to merge in the changes, especially if using the Tango catalog.

## 3.2.0 - 2023-06-08

### Changes
- Added blade views and its associated partials for reloadable card.
- Fix a bug where if a catalog item does not have a (appropriate) link to the item, then it should not link to another page.

### Upgrading
- If using Catalog module, you may need to upgrade to version 3.3.0 to make sure Catalog\Entities\Item::hasUrl() exists.

## 3.1.0 - 2023-06-06

### Changes
- Added disclaimer text (for Tango cards) to `views/catalog/item/show.blade.php`.

### Upgrading
- If you have a local copy of the `views/catalog/item/show.blade.php` file in your program theme, then you may need to merge the changes.

## 3.0.15.1 - 2023-03-26

### Changes
- Hotfix to `views/partials/_components/analytics.blade.php` to make G4 to GA4 for consistency.

## 3.0.15 - 2023-01-19

### Changes
- Added `transaction-points-update.blade.php` for `Ignite\Core\Notifications\NotifyParticipantWithTransactionPointsStatus`. This blade template is to send email when a participant receives points during transaction import.

## 3.0.14.1 - 2023-01-11

### Changes
- We were missing a layout file `layouts.mail` for `post-import-details.blade.php`. It is updated so that the blade file now uses the same mail layout (`@component('mail::message')`) as the other emails, and is a markdown format file now.

## 3.0.14 - 2023-01-05

### Changes
- Added `post-import-details.blade.php` for `Ignite\Core\Notifications\NotifyProgramManagerWithPostImportInfo`.

## 3.0.13 - 2022-12-21

### Changes
- Fixed `views/emails/general.php` to `views/emails/general.blade.php`
- Updated `views/partials/_components/favicon.blade.php`

## 3.0.11 - 2022-08-22

### Changes
- Updated CSS to include a red asterisk after required fields, like the backend. ([BSDP-13](https://brightspot.atlassian.net/browse/BSDP-13))

### Upgrading
- The red asterisk for required fields may automatically appear in your program admin back-end, but for it to appear in your front-end forms (like enrollment), you may have to re-compile your theme. Go to your theme folder and redo npm or yarn install and run to update your public stylesheet files.
- Also, if your forms tries to over-write the labels by adding asterisks manually, you may need to undo those.

## 3.0.10 - 2022-06-04

### Changes
- Updated catalog item show and item to present class name on catalog item.

## 3.0.9 - 2022-05-25

### Changes
- Added dist/javascripts/scripts.js and dist/mix-manifest.json for new sites that will be using the default theme instead of their own theme.
- Fixed a JS error in views/participant/profile/edit.blade.php with datetimepicker.

## 3.0.8 - 2022-05-04

### Changes
- Change Order on "My Transactions Page" -- Updated transaction index to include moment.js and order dates by 'd/m/YYYY'
