<div class="item text-center mb-3">
    <a href="{{ $item->getUrl() }}" class="item__image-container item__image-container--miked">
        <img class="item__image img-responsive" src="{{ $item->getImageUrl() }}">
        @if ($item->isCardType() && trim($item->class) && config('catalog.display_type_ribbon', true))
            <span class="item__image-ribbon">{{ $item->present()->getClass() }}</span>
        @endif
    </a>
    <a class="item__name" href="{{ $item->getUrl() }}" title="{{ $item->name }}">{{ $item->name }}</a>
    <small class="muted hidden-xs hidden-sm">{{ $item->manufacturer }}</small>
    @if ($item->isSimple())
    <h6 class="muted">{{ $item->getPoints() }} {{ __('Catalog::theme.general.points') }}</h6>
    @else
    <h6 class="muted">{{ $item->getTypeInstance()->getPointsRange() }} {{ __('Catalog::theme.general.points') }}</h6>
    @endif
    <div class="text-center">
        <a href="{{ $item->getUrl() }}" class="btn btn-primary mlr-auto btn-item">{{ __('Catalog::theme.cart.item.view.label') }}</a>
    </div>
    <a href="{{ $item->getFavoriteUrl() }}" class="item__favorite{{ $item->isFavorited() ? ' item__favorite--favorited' : '' }} " title="{{ $item->isFavorited() ? __('Catalog::theme.favorite.item.remove.label') : __('Catalog::theme.favorite.item.add.label') }}"><span class="icon"></span></a>
</div>
