@extends('layouts.site')

@section('meta_title', $item->name . ' | ' . $item->catalog->name)

@section('content')
    @include('partials._catalog.toolbar.toolbar')
    <section class="container mt-2">
        @include('partials._catalog.toolbar.breadcrumbs', [
            'breadcrumbClass' => 'col-xs-12',
            'crumbs' => [
                ['url' => '', 'title' => $item->name]
            ],
            'linkCatalog' => true
        ])
        <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-9 pull-right">
                <div class="panel-stack-shadow">
                    <div class="panel panel-squared mb-4">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-xs-12 col-sm-8">
                                    <div class="mb-2">
                                        <h3 class="m-0">{{ $item->name }}</h3>

                                    @if ($item->isConfigurable())
                                        <h6 class="item__price-container"><strong class="item__price">{{ $item->getTypeInstance()->getPointsRange() }}</strong> {{ __('Catalog::theme.general.points') }}</h6>
                                    @else
                                        <h6 class="item__price-container"><strong class="item__price">{{ $item->getPoints() }}</strong> {{ __('Catalog::theme.general.points') }}</h6>
                                    @endif
                                    </div>
                                    <div class="item__image-container mt-2 mb-2">
                                        <img class="img-responsive item__image--rounded" src="{{ $item->getImageUrl() }}" />
                                        @if ($item->isCardType() && trim($item->class) && config('catalog.display_type_ribbon'))
                                        <span class="item__image-ribbon">{{ $item->present()->getClass() }}</span>
                                        @endif
                                    </div>
                                    <div class="lead">
                                        {!! $item->getDescription() !!}
                                    </div>
                                </div>
                                <div class="col-xs-12 col-sm-4">
                                    <form method="post" action="{{ route('catalog.cart.store') }}">
                                        {{ csrf_field() }}
                                        <input type="hidden" id="itemId" name="item_id" value="{{ $item->getKey() }}" />

                                        @if ($item->isConfigurable() && $item->getTypeInstance()->hasOptions())
                                            @foreach ($item->getTypeInstance()->getOptions() as $option)
                                                @php $attribute = $option->first()->attribute; @endphp
                                                <div class="form-group" id="option-{{ $attribute->code }}">
                                                    <label for="option-{{ $attribute->code }}" class="control">{{ $attribute->label }}</label>
                                                    @include("partials._catalog.options." . $attribute->type, [
                                                        'attribute' => $attribute,
                                                        'options' => $option
                                                    ])
                                                </div>
                                            @endforeach
                                        @endif

                                        <div class="form-group">
                                            <label for="quantity" class="control">{{ __('Catalog::theme.general.quantity') }}</label>
                                            <select id="quantity" class="form-control" name="quantity">
                                                @foreach(range(1, 10) as $num)
                                                    <option value="{{ $num }}">{{ $num }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            @if ($item->isSimple() || ($item->isConfigurable() && $item->getTypeInstance()->hasOptions()))
                                            <button type="submit" class="btn btn-primary btn-block" name="cartType" value="cart">
                                                <span class="fa-solid fa-shopping-cart"></span>
                                                {{ __('Catalog::theme.cart.item.add.label') }}
                                            </button>
                                            @endif
                                            <a href="{{ $item->getFavoriteUrl() }}" class="btn btn-default btn-block">
                                                <span class="text-danger {{ $item->isFavorited() ? 'fa-solid' : 'fa-regular' }} fa-heart"></span>
                                                <small>
                                                @if ($item->isFavorited())
                                                    {{ __('Catalog::theme.favorite.item.remove.label') }}
                                                @else
                                                    {{ __('Catalog::theme.favorite.item.add.label') }}
                                                @endif
                                                </small>
                                            </a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            @if ('' !== trim($item->disclaimer))
                                <div class="panel-fit clearfix">
                                    <div class="panel-body">
                                        <div class="text-block">{!! $item->getDisclaimer() !!}</div>
                                    </div>
                                </div>
                            @endif
                            @if ('' !== trim($item->terms))
                            <div class="panel-fit clearfix">
                                <div class="panel-group p-0 m-0" id="accordion" role="tablist" aria-multiselectable="true">
                                    <div class="panel panel-transparent p-0 m-0">
                                        <div class="panel-heading" role="tab" id="headingOne">
                                            <h4 class="panel-title">
                                                <a href="#item-terms" class="collapsible" role="button" data-toggle="collapse" data-parent="#accordion" aria-expanded="false" aria-controls="collapseOne">
                                                    <span class="fa-solid fa-chevron-down"></span> {{ __('Catalog::theme.general.terms') }}
                                                </a>
                                            </h4>
                                        </div>
                                        <div id="item-terms" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingOne">
                                            <div class="panel-body">
                                                <div class="text-block">{!! $item->getTerms() !!}</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 pull-left catalog-filters" id="catalog-filters">
                @include('partials._catalog.sidebar')
            </div>
        </div>
    </section>
@endsection

@section('js')
    @parent
    <script src="{{ asset('/vendor/ignite/js/catalog/catalog.js') }}"></script>
@endsection
