@extends('layouts.site')

@section('meta_title', __(":type Submitted", ['type' => $type->singular()]))

@section('content')

    <section class="container-centered-large activity-type-show">
        <div class="panel mt-4 mb-4">
            <div class="panel-heading">
                <div class="col-md-12">
                    <h2 class="text-center mb-4">{{ __('Success!') }}</h2>
                </div>
            </div>
            <div class="panel-body clearfix">
                <div class="row">
                    <div class="col-sm-8 col-sm-offset-2">
                        <div class="mt-3 text-center">
                            <div class="mt-0 mb-2">
                                <span class="fa-solid fa-check fa-4x text-success"></span>
                            </div>
                            <h4 class="mb-2">
                                {{ __('Your :type was submitted successfully.', ['type' => $type->singular()]) }}
                            </h4>
                            <p class="mb-4 lead">
                                {{ __('You will receive an email confirmation shortly.') }}
                            </p>
                            <h3 class="text-muted mb-4">
                                {{ __('Record Number: #:number', ['number' => $activity->getKey()]) }}
                            </h3>
                            <div class="mb-4">
                                <a href="{{ route('activity.create', compact('type', 'offer')) }}" class="btn btn-primary">
                                    Submit another?
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
