<form id="reloadable-form" method="post" class="form-horizontal" action="{{ route('catalog.hawk-reloadable.store') }}">
    {{ csrf_field() }}
    <input type="hidden" id="itemId" name="item_id" value="{{ $item->getKey() }}" />

    @if ($threshold->verify())
        <div class="form-group form-input">
            <label for="amount" class="col-xs-7 col-sm-7 control-label text-right">Load Amount$<em class="text-danger">*</em></label>
            <div class="col-xs-5 col-sm-5">
                <input type="number" class="form-control" id="amount" name="amount" value="{{ old('amount', ($threshold->amount() > 1 ? $threshold->amount() : '')) }}" />
                <span id="amount-dollars"></span>
                @if ($errors->has('amount'))
                    <span class="help-block" style="color: #c00;">{{ $errors->first('amount') }}</span>
                @endif
            </div>
        </div>
        @if (! $threshold->hasCreatedReloadableCard())
            @include('catalog.reloadable._partials.info-fields')
        @endif
        <div class="form-group text-right">
            <div class="col-xs-12">
                <button type="submit" class="btn btn-primary pull-right">Submit Order</button>
            </div>
        </div>
    @endif
</form>

@section('js')
    @parent
    @php
    $conversion = $threshold->getDollarsPerPoint();
    @endphp
    <script>
        jQuery(document).ready(function($) {
            function updatePointsAmount() {
                {{-- if conversion is 1, do nothing --}}
                @if ($conversion != 1)
                var value = Math.ceil($('#amount').val() / {{ $conversion }});
                $('#amount-dollars').html('= ' + value + ' points');
                @endif
            };
            $('#amount').on('change', updatePointsAmount);
            updatePointsAmount();
        })
    </script>
@endsection
