@extends('layouts.site')

@section('meta_title', $item->name . ' | ' . $item->catalog->name)

@section('content_alert')

@endsection

@php
    $amountText = $threshold->amount() . ' ' . str_plural('point', $threshold->amount());
    $description = preg_replace('/([0-9]+)\s(points)/', $amountText, $item->description);
    $minRequiredAmount = $threshold->getMinRequiredAmount();
@endphp

@section('content')
    <section class="container mt-2">
        @include('catalog.reloadable._partials.toolbar')
        @if (session('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif
        <div class="row">
            <div class="col-xs-12">
                <div class="panel-stack-shadow">
                    <div class="panel panel-squared mb-4">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-xs-12 col-md-{{ $threshold->hasCreatedReloadableCard() ? '8' : '6' }}">
                                    <div class="mb-2">
                                        <h3 class="m-0">{{ $item->name }}</h3>
                                        <hr />
                                    </div>
                                    <div class="item__image-container mt-2 mb-2">
                                        <img class="img-responsive item__image--rounded" src="{{ Theme::image($item->image) }}" />
                                    </div>
                                    <div class="lead">
                                        {!! $description !!}
                                    </div>
                                </div>
                                <div class="col-xs-12 col-md-{{ $threshold->hasCreatedReloadableCard() ? '4' : '6' }}">
                                    @if ($minRequiredAmount > 0)
                                        <div class="alert alert-warning mb-2">
                                            <p class="m-0 text-left"><span class="fa fa-exclamation-circle"></span> Important</p>
                                            <p class="mt-1 text-left text-normal" style="font-weight: 400">You'll need to load at least {{ $minRequiredAmount }} {{ str_plural('dollar', $minRequiredAmount) }} onto the card.
                                        </div>
                                    @endif
                                    <div class="js-errors alert alert-danger mb-3"></div>
                                    @include('catalog.reloadable._partials.form')
                                </div>
                            </div>
                            @if ('' !== trim($item->terms))
                                <div class="panel-fit clearfix">
                                    <div class="panel-group p-0 m-0" id="accordion" role="tablist" aria-multiselectable="true">
                                        <div class="panel panel-transparent p-0 m-0">
                                            <div class="panel-heading" role="tab" id="headingOne">
                                                <h4 class="panel-title">
                                                    <a href="#item-terms" class="collapsible" role="button" data-toggle="collapse" data-parent="#accordion" aria-expanded="false" aria-controls="collapseOne">
                                                        <span class="arrow"></span> Terms of Use
                                                    </a>
                                                </h4>
                                            </div>
                                            <div id="item-terms" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingOne">
                                                <div class="panel-body">
                                                    <div class="text-block">{!! $item->terms !!}</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('js')
    @parent
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.15/jquery.mask.min.js"></script>
    <script>
        jQuery(document).ready(function($) {
            $('div.js-errors').hide();
            jQuery.validator.addMethod("isInt", function (val, element) {
                return val % 1 === 0;
            }, "This needs to be a whole number");
            jQuery.validator.addMethod("state", function (state, element) {
                state = state.toUpperCase();
                return this.optional(element) || state.match(/^(A[LKSZRAEP]|C[AOT]|D[EC]|F[LM]|G[ANU]|HI|I[ADLN]|K[SY]|LA|M[ADEHINOPST]|N[CDEHJMVY]|O[HKR]|P[ARW]|RI|S[CD]|T[NX]|UT|V[AIT]|W[AIVY])$/);
            }, "Please specify a valid US state");
            jQuery.validator.addMethod("phoneUS", function(phone, element) {
                 return phone.length === (10 + 4);
            }, "Please enter a valid US phone.");
            jQuery.validator.addMethod("emailDomain", function(email, element) {
                if (email == '' || email.match(/@([a-z0-9\-]+\.)+[a-z]{2,}$/i)) {
                    return true;
                }
                return false;
            }, "Please enter valid email adderss.");
            jQuery.validator.addMethod("zip", function(zip, element) {
                return zip.length === 5;
            }, "Please enter a 5 digit zip code.");
            $('#postal').mask('00000');
            $('#ship-phone').mask('(000) 000-0000');
            $('#reloadable-form').validate({
                rules: {
                    amount: {
                        required: true,
                        min: {{ $minRequiredAmount }},
                        max: {{ $threshold->amount() }},
                        isInt: true
                    },
                    "info[ship_phone]": {
                        required: true,
                        phoneUS: true
                    },
                    "info[ship_email]": {
                        email: true,
                        emailDomain: true,
                    },
                    "info[ship_address_1]": {
                        required: true
                    },
                    "info[ship_city]": {
                        required: true
                    },
                    "info[ship_state]": {
                        required: true,
                        state: true
                    },
                    "info[ship_postal]": {
                        required: true,
                        digits: true,
                        zip: true
                    }
                },
                errorElement: 'em',
                errorPlacement: function (error, element) {
                    error.addClass('help-block');
                    if (element.prop('type') === 'checkbox') {
                        error.insertAfter(element.parent('label'));
                    } else if (element.hasClass('select2')) {
                        error.insertAfter(element.siblings('.select2-container'));
                    } else {
                        error.insertAfter(element);
                    }
                },
                invalidHandler: function(event, validator) {
                    var errors = validator.numberOfInvalids();
                    if (errors) {
                        $("div.js-errors").hide();
                        $("div.js-errors").html('You have some invalid data. Please update and try again.');
                        $("div.js-errors").fadeIn();
                    } else {
                        $("div.js-errors").hide();
                    }
                },
                success: function (label, element) {},
                highlight: function (element, errorClass, validClass) {
                    $(element).parents('.form-input').addClass('has-error');
                },
                unhighlight: function (element, errorClass, validClass) {
                    $(element).parents('.form-input').removeClass('has-error');
                }
            });
        })
    </script>
@endsection
