@extends('layouts.site')

@section('meta_title', 'My Transactions')

@section('css')
    @parent
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.19/css/dataTables.bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/rowgroup/1.1.0/css/rowGroup.bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.3.1/css/buttons.bootstrap.min.css">
@endsection

@section('content_header')
    @include('partials._components._heading', ['heading' => 'My Transactions'])
@endsection

@section('content')
    <section class="container transaction-index">
        <div class="row pb-4">
            <div class="col-md-4">
                @include('partials._components._user-menu')
            </div>
            <div class="col-md-8">
                <div class="row mt-4 mb-1">
                    @foreach($summary->except('issued') as $metric)
                        <div class="col-md-4">
                            <div class="panel panel-default stat stat-{{ $metric->style('gray') }} stat-border-top">
                                <div class="panel-body">
                                    <p class="mb-0 stat-value">{{ $metric->total() }}</p>
                                    <p class="mt-0 stat-label">
                                        @if ($metric->name() === 'balance')
                                            {{ Program::isPayout() ? 'current balance' : 'current '.strtolower(trans_choice('Core::core.common.points', 2)) }}
                                        @else
                                            {{ Program::isPayout() ? 'total amount ' . $metric->name() : 'total '.strtolower(trans_choice('Core::core.common.points', 2)) .' '. $metric->name() }}
                                        @endif
                                    </p>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                @if ($transactions->count() > 0)
                    <table class="table table-striped mb-0" id="transactionsTable">
                        <thead>
                            <tr>
                                <th>Id</th>
                                <th>Date</th>
                                <th>Type</th>
                                <th class="hidden-xs">Description</th>
                                <th class="text-right">Value</th>
                            </tr>
                        </thead>
                        <tbody>
                        @forelse($transactions as $transaction)
                            <tr>
                                <td>{{ $transaction['id'] }}</td>
                                <td>{{ Format::datetime($transaction['created_at'], 'm/d/Y') }}</td>
                                <td>{{ $transaction['type'] }}</td>
                                <td class="hidden-xs">{!! str_replace("\n", "<br />\n", $transaction['description']) !!}</td>
                                <td class="text-right">{{ Format::amount($transaction['value']) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-danger text-center">No transactions found.</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                @endif
            </div>
        </div>
    </section>
@endsection

@section('js')
    @parent
    <script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/dataTables.bootstrap.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/rowgroup/1.1.0/js/dataTables.rowGroup.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.4/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.html5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.colVis.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.print.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.4/js/buttons.bootstrap.min.js"></script>
    <script type="text/javascript">
        $.extend($.fn.dataTableExt.oStdClasses, {
            "sFilterInput": "dataTables_filter form-control",
            "sLengthSelect": "dataTables_length form-control"
        });
        var transactionsDataTable = $('#transactionsTable').DataTable({
            order: [[0, 'asc']],
            dom: '<"row"<"col-md-6 text-left"f><"col-md-6 text-right"l<"mr-1 pull-right"B>>><"panel mt-2 mb-1"<"panel-body"<"negative-margin table-responsive"t>>><"row"<"col-md-6"i><"col-md-6"p>>',
            responsive: true,
            autoWidth: false,
            language: {
                search: '',
                searchPlaceholder: "Search...",
                lengthMenu: '_MENU_'
            },
            buttons: ['csv']
        });
    </script>
@endsection
