@extends('layouts.site')
@section('meta_title', 'My Profile')
@section('content_header')
    @include('partials._components._heading', ['heading' => 'My Profile'])
@endsection
@section('content')
    <section class="container participant-profile-show">
        <div class="row">
            <div class="col-md-4">
                @include('partials._components._user-menu')
            </div>
            <div class="col-md-8">
                <div class="panel panel-default mt-4 mb-4">
                    <div class="panel-heading">
                        <div class="clearfix">
                            <strong class="panel-title pull-left fullname" style="padding-top: 4px; text-shadow: 1px 1px 0 #fff;">{{ auth()->user()->fullName() }}</strong>
                            <div class="btn-group pull-right">
                                <a href="{{ route('participant.profile.edit') }}" class="btn btn-sm btn-default edit-profile-button"><span class="fa fa-cog"></span> Edit Profile</a>
                                <a href="{{ route('participant.password.edit') }}" class="btn btn-sm btn-default change-password-button"><span class="fa fa-key"></span> Change Password</a>
                            </div>
                        </div>
                    </div>
                    <div class="panel-body">
                        @yield('content-main')
                        {!! form($form) !!}
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection

@section('js')
    @parent
    @include('partials._participant.conditionals')
@endsection
