@component('mail::message')
# Checked Orders Report Notification

Hi, {{ $orderItems->count() }} order items are still marked as processing. Please investigate and, if possible, mark them as processed/cancelled. If you are unable to mark them as processed or cancelled, please contact IT.

---

@php
    $groupedItems = $orderItems->groupBy(function ($item) {
        return $item->order->number;
    });
@endphp

@foreach ($groupedItems as $orderNumber => $groupOrderItems)
## \#{{ $orderNumber }}
### {{ $groupOrderItems->first()->order->ship_name }} | {{ $groupOrderItems->first()->order->ship_email }}
@if ($groupOrderItems->isNotEmpty())
@component('mail::table')
| Name                   | Cost                   | Quantity                   |
|:---------------------- | ----------------------:| --------------------------:|
@foreach($groupOrderItems as $orderItem)| {{ $orderItem->name }} | {{ $orderItem->cost }} | {{ $orderItem->quantity }} |
@endforeach
@endcomponent
---
@endif

@endforeach
Thanks,<br>
{{ config('app.name') }}
@endcomponent
