@extends('layouts.site')

@section('meta_title', 'My Claims')

@section('css')
    @parent
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.19/css/dataTables.bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/rowgroup/1.1.0/css/rowGroup.bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.3.1/css/buttons.bootstrap.min.css">
@endsection

@section('content_header')
    @include('partials._components._heading', ['heading' => 'My Claims'])
@endsection

@section('content')
    <section class="container">
        <div class="row">
            <div class="col-md-4">
                @include('partials._components._user-menu')
            </div>
            <div class="col-md-8">
                <div class="row mt-4 mb-1">
                    @foreach($summary->except(['cancelled', 'issued']) as $metric)
                        <div class="col-md-4">
                            <div class="panel panel-default stat stat-{{ $metric->style('gray') }} stat-border-top">
                                <div class="panel-body">
                                    <div class="circle-stat pull-right" data-value="{{ $metric->percentage($summaryTotal) }}" data-fill='"{{ $metric->color() }}"'>
                                        <strong class="circle-stat-value">{{ $count = $metric->count() }}</strong>
                                    </div>
                                    <p class="mb-0 stat-value">{{ $metric->total() }}</p>
                                    <p class="mt-0 stat-label">{{ $count }} {{ $metric->name() }} {{ \Illuminate\Support\Str::plural('claim', $count) }} </p>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                @if ($claimParticipants->count() > 0)
                <table class="table table-striped mb-0" id="claimsTable">
                    <thead>
                    <tr>
                        <th class="pl-3 text-left">Claim ID</th>
                        <th>Date Submitted</th>
                        <th>Status</th>
                        <th class="pr-3 text-right">Amount</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($claimParticipants as $claimParticipant)
                        <tr>
                            <td class="pl-3 text-left">{{ $claimParticipant['claim']['id'] }}</td>
                            <td>{{ Format::datetime($claimParticipant['claim']['created_at']) }}</td>
                            <td>
                                @php
                                    $status = trim(ucwords($claimParticipant['status']));
                                @endphp
                                @if ('Declined' === $status)
                                    <span class="fa fa-circle stat-red"></span> <span class="stat-red">{{ $status }}</span>
                                @elseif ('Approved' === $status)
                                    <span class="fa fa-circle stat-green"></span> <span class="stat-green">{{ $status }}</span>
                                @elseif ('Cancelled' === $status)
                                    <span class="fa fa-circle stat-red"></span> <span class="text-default">{{ $status }}</span>
                                @elseif ('Issued' === $status)
                                    <span class="fa fa-circle text-primary"></span> <span class="text-primary">{{ $status }}</span>
                                @elseif ('Pending' === $status)
                                    <span class="fa fa-circle stat-orange"></span> <span class="stat-orange">{{ $status }}</span>
                                @else
                                    <span class="fa fa-circle text-gray"></span>{{ $status }}
                                @endif
                            </td>
                            <td class="pr-3 text-right">{{ Format::balance($claimParticipant['value']) }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-danger text-center">No claims found.</td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
                @else
                    <div class="panel panel-transparent text-center">
                        <div class="panel-body my-5">
                            <h5 class="mt-3">You haven't submitted any claims yet.</h5>
                            <a class="btn btn-primary mt-3" href="{{ route('claim.create') }}">Submit a Claim</a>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </section>
@endsection

@section('js')
    @parent
    <script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/dataTables.bootstrap.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/rowgroup/1.1.0/js/dataTables.rowGroup.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.4/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.html5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.colVis.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.print.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.4/js/buttons.bootstrap.min.js"></script>
    <script type="text/javascript">
      $(document).ready(function(){
        $.extend($.fn.dataTableExt.oStdClasses, {
            "sFilterInput": "dataTables_filter form-control",
            "sLengthSelect": "dataTables_length form-control"
        });
        var ordersDataTable = $('#claimsTable').DataTable({
            order: [[0, 'desc']],
            dom: '<"row"<"col-md-6 text-left"f><"col-md-6 text-right"l<"mr-1 pull-right"B>>><"panel mt-2 mb-1"<"panel-body"<"negative-margin table-responsive"t>>><"row"<"col-md-6"i><"col-md-6"p>>',
            columnDefs: [{orderable: false, targets: []}, {targets: [], visible: false} ],
            responsive: true,
            autoWidth: false,
            language: {
                search: '',
                searchPlaceholder: "Search...",
                lengthMenu: '_MENU_'
            },
            buttons: ['csv']
        });
      });
    </script>
@endsection
