@extends('layouts.site')

@section('meta_title', 'Enrollment')

@section('content')

    <section class="container-centered-large">
        <div class="panel mt-4 mb-4">
            <div class="panel-heading">
                <div class="col-md-12">
                    @if ($page->hasContent())
                        {!! $page->getContent() !!}
                    @else
                        <h2 class="text-center mb-4">Enrollment</h2>
                    @endif
                </div>
            </div>
            <div class="panel-body clearfix">
                {!! form($form) !!}
            </div>
        </div>
    </section>

@endsection

@section('js')
    @parent
    <script type="text/javascript" src="{{ Theme::script('conditionals.js') }}"></script>
    <script>
        jQuery(document).ready(function($) {
            window.Participant = window.Participant || {};
            window.Participant.Enrollment = window.Participant.Enrollment || {};
            window.Participant.Enrollment.states = window.Participant.Enrollment.states || [];
            window.Participant.Enrollment.states.US = @json(app(\Ignite\Core\Models\Options\States::class)->toDropdown());
            window.Participant.Enrollment.states.CA = @json(app(\Ignite\Core\Models\Options\CanadaStates::class)->toDropdown());

            $('#enrollment-form').conditionals({
                rules: [
                    {
                        name: 'country',
                        triggers: ['country'],
                        fields: [],
                        conditions: [
                            {
                                checks: [
                                    {
                                        field: 'country',
                                        op: '=',
                                        value: 'US'
                                    }
                                ],
                                show: ['country', 'state'],
                                required: ['country', 'state'],
                                onHandle: function () {
                                    this.toggleInputSelectOptions($('#state'), window.Participant.Enrollment.states.US);
                                }
                            },
                            {
                                checks: [
                                    {
                                        field: 'country',
                                        op: '=',
                                        value: 'CA'
                                    }
                                ],
                                show: ['country', 'state'],
                                required: ['country', 'state'],
                                onHandle: function () {
                                    this.toggleInputSelectOptions($('#state'), window.Participant.Enrollment.states.CA);
                                }
                            },
                            {
                                checks: [
                                    {
                                        field: 'country',
                                        op: 'notIn',
                                        value: ['CA', 'US']
                                    }
                                ],
                                show: ['country', 'state'],
                                required: ['country', 'state'],
                                onHandle: function (condition) {
                                    this.toggleSelectOptionsInput($('#state'), '');
                                }
                            }
                        ]
                    }
                ]
            });

            var icons = {
                time: "fa fa-clock-o",
                date: "fa fa-calendar",
                up: "fa fa-arrow-up",
                down: "fa fa-arrow-down",
                previous: 'fa fa-chevron-left',
                next: 'fa fa-chevron-right',
                today: 'fa fa-calendar-times-o',
                clear: 'fa fa-trash',
                close: 'fa fa-remove'
            };

            var $datetimepickers = $('.datetimepicker');
            $datetimepickers.length && $datetimepickers.datetimepicker({
                format: 'MM/DD/YYYY HH:mm:ss',
                icons: icons
            });

            var $datepickers = $('.datepicker');
            $datepickers.length && $datepickers.datetimepicker({
                format: 'MM/DD/YYYY',
                icons: icons
            });

            /*$('#submit-enrollment').length && $('#submit-enrollment').validate({
            errorElement: 'em',
            errorPlacement: function (error, element) {
              error.addClass('help-block');
              if (element.prop('type') === 'checkbox') {
                error.insertAfter(element.parent('label'));
              } else if (element.hasClass('select2')) {
                error.insertAfter(element.siblings('.select2-container'));
              } else {
                error.insertAfter(element);
              }
            },
            success: function (label, element) {},
            highlight: function (element, errorClass, validClass) {
              $(element).parents('.form-input').addClass('has-error');
            },
            unhighlight: function (element, errorClass, validClass) {
              $(element).parents('.form-input').removeClass('has-error');
            }
          });*/
        });
    </script>
@endsection
