<!DOCTYPE html>
<html lang="en">
@section('head')
<head>
    @if (config('theme.fonts'))<link href="https://fonts.googleapis.com/css?family={{ config('theme.fonts') }}" rel="stylesheet"/>@endif
    <meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <meta name="description" content="@yield('meta_description')"/>
    <meta name="keywords" content="@yield('meta_keywords')"/>
    <title>@yield('meta_title')</title>
    @section('css')
    <link rel="stylesheet" href="{{ Theme::mix('/stylesheets/styles.css') }}" />
    @stop
    @yield('css')
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="//oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
    <script src="//oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
@show
<body class="env-front-{{ config('app.env') }}">
<div class="page">
    @include('partials._components.header')
    @section('content_alert')
    @include('partials._components.alert')
    @show
    @yield('content_header')
    @yield('content')
    @yield('content_footer')
    <div class="push"></div>
</div>
@include('partials._components.footer')
@section('js')
    <script src="{{ Theme::mix('/javascripts/scripts.js') }}"></script>
@show
</body>
</html>
