@extends('layouts.site')

@section('meta_title', 'Enrollment')

@section('content')

    <section class="container-centered-large">
        <div class="panel mt-4 mb-4">
            <div class="panel-heading">
                <div class="col-md-12">
                    @if ($page->hasContent())
                        {!! $page->getContent() !!}
                    @else
                        <h2 class="text-center mb-4">Enrollment</h2>
                    @endif
                </div>
            </div>
            <div class="panel-body clearfix">
                {!! form($form) !!}
            </div>
        </div>
    </section>

@endsection

@section('js')
    @parent
    @include('partials._participant.conditionals')
    <script type="text/javascript">
        jQuery(document).ready(function($) {
            var icons = {
                time: "fa fa-clock-o",
                date: "fa fa-calendar",
                up: "fa fa-arrow-up",
                down: "fa fa-arrow-down",
                previous: 'fa fa-chevron-left',
                next: 'fa fa-chevron-right',
                today: 'fa fa-calendar-times-o',
                clear: 'fa fa-trash',
                close: 'fa fa-remove'
            };

            var $datetimepickers = $('.datetimepicker');
            $datetimepickers.length && $datetimepickers.datetimepicker({
                format: 'MM/DD/YYYY HH:mm:ss',
                icons: icons
            });

            var $datepickers = $('.datepicker');
            $datepickers.length && $datepickers.datetimepicker({
                format: 'MM/DD/YYYY',
                icons: icons
            });

            /*$('#submit-participant').length && $('#submit-participant').validate({
            errorElement: 'em',
            errorPlacement: function (error, element) {
              error.addClass('help-block');
              if (element.prop('type') === 'checkbox') {
                error.insertAfter(element.parent('label'));
              } else if (element.hasClass('select2')) {
                error.insertAfter(element.siblings('.select2-container'));
              } else {
                error.insertAfter(element);
              }
            },
            success: function (label, element) {},
            highlight: function (element, errorClass, validClass) {
              $(element).parents('.form-input').addClass('has-error');
            },
            unhighlight: function (element, errorClass, validClass) {
              $(element).parents('.form-input').removeClass('has-error');
            }
          });*/
        });
    </script>
@endsection
