<script type="text/javascript" src="{{ Theme::script('conditionals.js') }}"></script>
<script>
    jQuery(document).ready(function($) {
        window.Participant = window.Participant || {};
        window.Participant.Enrollment = window.Participant.Enrollment || {};
        window.Participant.Enrollment.states = window.Participant.Enrollment.states || [];
        window.Participant.Enrollment.states.US = @json(app(\Ignite\Core\Models\Options\States::class)->toDropdown());
        window.Participant.Enrollment.states.CA = @json(app(\Ignite\Core\Models\Options\CanadaStates::class)->toDropdown());

        $('#enrollment-form, #profile-form').conditionals({
            select2: {
                theme: '{{ $form->isViewingBackend() ? 'default' : 'bootstrap' }}'
            },
            rules: [
                {
                    name: 'country',
                    triggers: ['country'],
                    fields: [],
                    conditions: [
                        {
                            checks: [
                                {
                                    field: 'country',
                                    op: '=',
                                    value: 'US'
                                }
                            ],
                            show: ['country', 'state'],
                            required: ['country', 'state'],
                            onHandle: function () {
                                this.toggleInputSelectOptions($('#state'), window.Participant.Enrollment.states.US);
                            }
                        },
                        {
                            checks: [
                                {
                                    field: 'country',
                                    op: '=',
                                    value: 'CA'
                                }
                            ],
                            show: ['country', 'state'],
                            required: ['country', 'state'],
                            onHandle: function () {
                                this.toggleInputSelectOptions($('#state'), window.Participant.Enrollment.states.CA);
                            }
                        },
                        {
                            checks: [
                                {
                                    field: 'country',
                                    op: 'notIn',
                                    value: ['CA', 'US']
                                }
                            ],
                            show: ['country', 'state'],
                            required: ['country', 'state'],
                            onHandle: function (condition) {
                                this.toggleSelectOptionsInput($('#state'), '');
                            }
                        }
                    ]
                }
            ]
        });
    });
</script>