@extends('layouts.site')
@section('meta_title', 'Catalog')

@section('content')

@include('partials._catalog.toolbar.buttons', ['class' => 'm-0'])

@if (isset($page) && $page->hasContent())
<div class="page-content white">
    <section class="container">
        <div class="row">
            <div class="col-md-12">
                {!! $page->getContent() !!}
            </div>
        </div>
    </section>
</div>
@endif
<div class="page-content">
    <section class="container">
        <div class="row text-center">
            @php $catalogCount = $catalogs->count(); @endphp
            @if ($catalogCount > 0)
                @foreach($catalogs as $catalog)
                <div class="mb-3 col-sm-6 {{ $catalogCount === 1 ? 'center-block' : '' }}" {!! $catalogCount === 1 ? 'style="float:none !important"' : '' !!}>
                    <a style="display: block" class="panel" href="{{ route('catalog.show', ['catalog' => $catalog->code]) }}">
                        <img class="img-responsive" src="{{ Theme::image("{$catalog->code}.jpg") }}" alt="{{ $catalog->name }}" />
                        <h2 class="panel-title text-left p-3" style="text-decoration: none !important;">{{ $catalog->name }}</h2>
                    </a>
                </div>
                @endforeach
            @else
                <div class="alert alert-danger">
                    Sorry, we don't support your country.
                </div>
            @endif
        </div>
    </section>
</div>

@endsection

@section('js')
@parent
@endsection