@extends('layouts.site')

@section('meta_title', 'My Orders')

@section('css')
    @parent
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.19/css/dataTables.bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/rowgroup/1.1.0/css/rowGroup.bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.3.1/css/buttons.bootstrap.min.css">
@endsection

@section('content_header')
    @include('partials._components._heading', ['heading' => 'My Orders'])
@endsection

@section('content')
    <section class="container">
        <div class="row">
            <div class="col-md-4">
                @include('partials._components._user-menu')
            </div>
            <div class="col-md-8">
                <div class="row mt-4 mb-1">
                    @foreach($summary->except('issued') as $metric)
                        <div class="col-md-4">
                            <div class="panel panel-default stat stat-{{ $metric->class('gray') }} stat-border-top">
                                <div class="panel-body">
                                    <div class="circle-stat pull-right" data-value="<?php echo $metric->percentage($summaryTotal) ?>" data-fill='"{{ $metric->color() }}"'>
                                        <strong class="circle-stat-value">{{ $count = $metric->count() }}</strong>
                                    </div>
                                    <p class="mb-0 stat-value">{{ $metric->total() }}</p>
                                    <p class="mt-0 stat-label">{{ $count = $metric->count() }} {{ \Illuminate\Support\Str::plural('order', $count) }} {{ $metric->name() }}</p>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                <table class="table table-striped mb-0" id="ordersTable">
                    <thead>
                        <tr>
                            <th>Order</th>
                            <th>Date</th>
                            <th>Items</th>
                            <th class="text-right"><span class="hidden-xs">Total </span>Points</th>
                            <th>&nbsp;</th>
                        </tr>
                    </thead>
                    <tbody>
                    @forelse($orders as $order)
                        <tr>
                            <td>{{ $order->number }}</td>
                            <td>{{ $order->created_at->format('jS F, Y') }}</td>
                            <td>{{ $order->totalQuantity()}}</td>
                            <td class="text-right">{{ $order->totalPoints() }}</td>
                            <td class="text-right">
                                <a style="padding: 5px !important; min-width: auto;" class="btn btn-xs btn-default" href="{{ route('catalog.order.show', $order->number) }}">View</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-danger text-center">No orders found.</td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </section>
@endsection

@section('js')
    @parent
    <script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.10.19/js/dataTables.bootstrap.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/rowgroup/1.1.0/js/dataTables.rowGroup.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.4/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.html5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.colVis.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.print.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.4/js/buttons.bootstrap.min.js"></script>
    <script type="text/javascript">
        $(document).ready(function(){
            $.extend($.fn.dataTableExt.oStdClasses, {
                "sFilterInput": "dataTables_filter form-control",
                "sLengthSelect": "dataTables_length form-control"
            });
            var ordersDataTable = $('#ordersTable').DataTable({
                order: [[0, 'desc']],
                dom: '<"row"<"col-md-6 text-left"f><"col-md-6 text-right"l<"mr-1 pull-right"B>>><"panel mt-2 mb-1"<"panel-body"<"negative-margin table-responsive"t>>><"row"<"col-md-6"i><"col-md-6"p>>',
                columnDefs: [{orderable: false, targets: []}, {targets: [], visible: false} ],
                responsive: true,
                autoWidth: false,
                language: {
                    search: '',
                    searchPlaceholder: "Search...",
                    lengthMenu: '_MENU_'
                },
                buttons: ['csv']
            });
        });
    </script>
@endsection
