@extends('layouts.site')
@section('meta_title', 'Reset your Password')
@section('content')

    <section class="container-centered">
        <div class="panel mt-5">
            <div class="panel-heading mt-4 mb-0 text-center">
                <span class="fa fa-key fa-4x"></span>
                <h4 class="panel-title mt-2 mb-1">Reset Password</h4>
                <p>Please enter your email so we can send you a new password.</p>
            </div>
            <div class="panel-body">
                <form class="form-classic" role="form" id="form_default_access_reset" method="POST" action="{{ route('password.email') }}">
                    {{ csrf_field() }}
                    <div class="block-inner">
                        <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                            <label for="reset-email" class="form-label">Email</label>
                            <input type="email" id="reset-email" name="email" class="form-control form-control-has-validation" value="{{ old('email') }}" maxlength="255" required autofocus />
                            @if ($errors->has('email'))
                            <span class="help-block">
                                  <strong>{{ $errors->first('email') }}</strong>
                            </span>
                            @endif
                        </div>
                    </div>
                    <div class="form-group mb-0">
                        <button class="btn btn-primary btn-round-bottom btn-block" type="submit">Reset password</button>
                    </div>
                </form>
            </div>
        </div>
        <div class="text-center">
            <span class="text-08">Remember it?</span>
            <a href="{{ route('login') }}" class="link link-primary-inverse">Sign In.</a>
        </div>
    </section>

@endsection