@extends('layouts.site')

@section('meta_title', 'My Transactions')

@section('css')
    @parent
    <link rel="stylesheet" href="https://cdn.datatables.net/v/dt/dt-1.10.15/datatables.min.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/rowgroup/1.0.0/css/rowGroup.bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.3.1/css/buttons.bootstrap.min.css">
@endsection

@section('content_header')
    @include('partials._components._heading', ['heading' => 'My Transactions', 'image' => false, 'color' => 'blue'])
@endsection

@section('content')

    <section class="container">
        <div class="row">
            <div class="col-md-4">
                @include('partials._components._user-menu')
            </div>
            <div class="col-md-8">
                <div class="panel mt-4 mb-4">
                    <div class="panel-heading clearfix balance-heading">
                        <h5 class="panel-title pull-left">
                            <span class="balance-subtitle">Balance:</span>
                            <span class="balance-title">{{ Format::amount($balance) }}</span>
                        </h5>
                    </div>
                    <div class="panel-body table-responsive">
                        <div class="pull-right text-right" id="transactionsDTButtons"></div>
                        <table class="table" id="transactionsTable">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Date</th>
                                    <th>Type</th>
                                    <th class="hidden-xs">Description</th>
                                    <th class="text-right">Value</th>
                                </tr>
                            </thead>
                            <tbody>
                            @forelse($transactions as $transaction)
                                <tr>
                                    <td>{{ $transaction['id'] }}</td>
                                    <td>{{ Format::datetime($transaction['created_at'], 'm/d/Y') }}</td>
                                    <td>{{ $transaction['type'] }}</td>
                                    <td class="hidden-xs">{!! str_replace("\n", "<br />\n", $transaction['description']) !!}</td>
                                    <td class="text-right">{{ Format::amount($transaction['value']) }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-danger text-center">No transactions found.</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('js')
    @parent
    <script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.10.15/datatables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/rowgroup/1.0.0/js/dataTables.rowGroup.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.html5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.colVis.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.print.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.bootstrap.min.js"></script>
    <script type="text/javascript">
        $.extend($.fn.dataTableExt.oStdClasses, {
            "sFilterInput": "dataTables_filter form-control",
            "sLengthSelect": "dataTables_length form-control"
        });
        var transactionsDataTable = $('#transactionsTable').DataTable({
            'order': [[0, 'asc']],
            //columnDefs: [{orderable: false, targets: []}, {targets: [3,4], visible: false} ],
            responsive: true,
            autoWidth: false,
            language: {
                search: '',
                searchPlaceholder: "Search...",
                lengthMenu: '_MENU_'
            },
            buttons: []
        });

        transactionsDataTable.buttons().container().appendTo($('#transactionsDTButtons'));

    </script>
@endsection
