<form id="claimForm" class="form-classic" method="post" action="{{ $claimReviewUri }}">
    <input type="hidden" id="code" name="code" value="{{ $code }}" />
    <input type="hidden" id="filesCode" name="filesCode" value="{{ $filesCode ?? '' }}" />
    <input type="hidden" id="mode" name="mode" value="{{ $mode }}" />
    <input type="hidden" id="offer_promotion_id" name="offer_promotion_id" value="{{ $formData['offer_promotion_id'] }}" />
    <input type="hidden" id="claim_id" name="claim_id" value="{{ $formData['claim_id'] }}" />
    <input type="hidden" id="created_at" name="created_at" value="{{ $formData['created_at'] }}" />
    <input type="hidden" id="maxParticipants" name="maxParticipants" value="{{ $formData['maxParticipants'] ?? '' }}" />
    <input type="hidden" id="maxLineitems" name="maxLineitems" value="{{ $formData['maxLineitems'] ?? '' }}" />
    {{ csrf_field() }}
    <div class="panel{{ !empty($isAdminLayout) ? ' panel-default' : '' }}">
        @if(! empty($isAdminLayout))
        <div class="panel-heading">
            <div class="panel-title">
                <strong style="margin: 0; padding-top: 5px;">{{ __('Core::core.fields.external') }}</strong>
            </div>
        </div>
        @else
        <div class="panel-heading">
            <div class="panel-title">
                <strong style="margin: 0; padding-top: 5px;" class="align-middle">{{ __('Claim::claim.form_heading') }}</strong>
            </div>
        </div>
        @endif
        <div class="panel-body">
            @include('Claim::partials.claimFieldsExternal')

            @if (setting('claim.use_simplified_lineitems'))
                @include('Claim::partials.claimItemsSimplified_static')
            @endif
        </div>
    </div>

    @if(! empty($isAdminLayout) && $mode != 'new')
    <div class="panel">
        <div class="panel-heading">
            <div class="row form-inline">
                <div class="col-md-6">
                    <h3 style="margin: 0; padding-top: 5px;" class="align-middle">{{ __('Core::core.fields.internal') }}</h3>
                </div>
                <div class="col-md-6 text-right" style="padding-right: 15px !important;">
                    <label for="claimParticipantSelect">{{ __('Core::core.participant.singular') }}:</label>
                    <select style="margin-right: 20px" class="form-control" name="claimParticipantSelect" id="claimParticipantSelect">
                        @foreach($participantOptions as $id => $name)
                            <option value="{{ $id }}" @if ( $id == $formData['claim_participant']['id'] )selected="selected"@endif>{{ $name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
        <div class="panel-body">
            @include('Claim::partials.claimFieldsInternal')
        </div>
    </div>
    @endif

    @if($mode == 'new')
        @if ($formData['maxParticipants'] > 0)
            @include('Claim::partials.claimParticipantList_static')
        @endif
    @endif

    @if (! setting('claim.use_simplified_lineitems'))
        @include('Claim::partials.claimItemsList_static')
    @endif

    @if (! empty($documentTypes) )
        @include('Claim::partials.claimFiles')
    @endif

    @if(! empty($isAdminLayout))
    <div class="row">
        <div class="col-xs-12 col-md-10 col-md-offset-1">
            <div class="form-actions text-center">
                @if ($mode == 'new')
                    <a class="btn btn-danger" href="/admin/claim/promotions">{{ __('Core::core.buttons.cancel') }}</a>
                @else
                    <a class="btn btn-danger" href="/admin/claim/list/{{ $listType }}">{{ __('Core::core.buttons.cancel') }}</a>
                @endif
                <button type="submit" class="btn btn-primary" id="review" value="Review">{{ __('Core::core.buttons.review') }}</button>
            </div>
        </div>
    </div>
    @else
    <hr />
    <div class="form-group text-center clearfix">
        <a class="btn btn-default" href="/claim/promotions">{{ __('Core::core.buttons.cancel') }}</a>
        <button type="submit" class="btn btn-primary" id="review">{{ __('Core::core.buttons.review') }}</button>
    </div>
    @endif
</div>
</form>
