<div class="item text-center mb-3">
    <a href="{{ $item->getUrl() }}" class="item__image-container item__image-container--miked">
        <img class="item__image img-responsive" src="{{ $item->getImageUrl() }}">
        @if ($item->isCardType() && trim($item->class) && config('catalog.item.display_type_ribbon', true))
            <span class="item__image-ribbon">{{ $item->class }}</span>
        @endif
    </a>
    <a class="item__name" href="{{ $item->getUrl() }}" title="{{ $item->name }}">{{ $item->name }}</a>
    <small class="muted hidden-xs hidden-sm">{{ $item->manufacturer }}</small>
    @if ($item->isSimple())
    <h6 class="muted">{{ $item->getPoints() }} Points</h6>
    @else
    <h6 class="muted">{{ $item->getTypeInstance()->getPointsRange() }} Points</h6>
    @endif
    <div class="text-center">
        <a href="{{ $item->getUrl() }}" class="btn btn-primary mlr-auto btn-item">View</a>
    </div>
    <a href="{{ $item->getFavoriteUrl() }}" class="item__favorite{{ $item->isFavorited() ? ' item__favorite--favorited' : '' }} " title="{{ $item->isFavorited() ? 'Remove from Favorites' : 'Add to Favorites' }}"><span class="fa"></span></a>
</div>
