@extends('layouts.site')
@section('meta_title', 'My Claims')
@section('content_header')
    @include('partials._components._heading', ['heading' => 'My Claims'])
@endsection
@section('content')

    <section class="container">
        <div class="row">
            <div class="col-md-4">
                @include('partials._components._user-menu')
            </div>
            <div class="col-md-8">
                <div class="row mt-4">
                    @foreach($summary->except('issued') as $metric)
                        <div class="col-md-4">
                            <div class="panel panel-default stat stat-{{ $metric->class('gray') }} stat-border-top">
                                <div class="panel-body">
                                    <div class="circle-stat pull-right" data-value="<?php echo $metric->percentage($summaryTotal) ?>" data-fill='"{{ $metric->color() }}"'>
                                        <strong class="circle-stat-value">{{ $metric->count() }}</strong>
                                    </div>
                                    <p class="mb-0 stat-value">{{ $metric->count() }}</p>
                                    <p class="mt-0 stat-label">{{ $metric->total() }} {{ $metric->name() }} claims </p>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="panel mt-2 mb-1">
                    <div class="panel-body nav-tabs-container">
                        <div id="claim-details" class="tab-pane fade in active">
                            <h5 class="mb-2 p-3 py-2 negative-margin content-title">
                                {{ $claimParticipants->count() }} {{ $status !== '' ? $status : 'total' }} claims
                            </h5>
                            @if (! empty($claimParticipants))
                            <div class="negative-margin">
                                <table class="table table-striped mb-0" id="claimsTable">
                                    <thead>
                                        <tr>
                                            <th class="pl-3 text-left">Claim ID</th>
                                            <th>Date Submitted</th>
                                            <th>Status</th>
                                            <th class="pr-3 text-right">Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($claimParticipants as $claimParticipant)
                                        <tr>
                                            <td class="pl-3 text-left">{{ $claimParticipant['claim']['id'] }}</td>
                                            <td>{{ Format::datetime($claimParticipant['claim']['created_at']) }}</td>
                                            <td>
                                                @php
                                                $status = trim(ucwords($claimParticipant['status']));
                                                @endphp
                                                @if ('Declined' === $status)
                                                    <span class="fa fa-circle stat-red"></span> <span class="stat-red">{{ $status }}</span>
                                                @elseif ('Approved' === $status)
                                                    <span class="fa fa-circle stat-green"></span> <span class="stat-green">{{ $status }}</span>
                                                @elseif ('Cancelled' === $status)
                                                    <span class="fa fa-circle stat-red"></span> <span class="text-default">{{ $status }}</span>
                                                @elseif ('Issued' === $status)
                                                    <span class="fa fa-circle text-primary"></span> <span class="text-primary">{{ $status }}</span>
                                                @elseif ('Pending' === $status)
                                                    <span class="fa fa-circle stat-orange"></span> <span class="stat-orange">{{ $status }}</span>
                                                @else
                                                    <span class="fa fa-circle text-gray"></span>{{ $status }}
                                                @endif
                                            </td>
                                            <td class="pr-3 text-right">{{ Format::balance($claimParticipant['value']) }}</td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="4" class="text-danger text-center">No claims found.</td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                            @else
                                <div class="alert alert-danger">
                                    <strong>No claims submitted.</strong>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
                {{ $claimParticipants->links() }}
            </div>
        </div>
    </section>

@endsection
