@extends('layouts.site')

@section('meta_title', 'My Orders')

@section('css')
    @parent
    <link rel="stylesheet" href="https://cdn.datatables.net/v/dt/dt-1.10.15/datatables.min.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/rowgroup/1.0.0/css/rowGroup.bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.3.1/css/buttons.bootstrap.min.css">
@endsection

@section('content_header')
    @include('partials._components._heading', [
        'heading' => 'My Orders',
    ])
@endsection

@section('content')

    <section class="container">
        <div class="row">
            <div class="col-md-4">
                @include('partials._components._user-menu')
            </div>
            <div class="col-md-8">
                <div class="panel mt-4 mb-4">
                    <div class="panel-heading clearfix balance-heading">
                        <h5 class="panel-title pull-left">
                            <span class="balance-subtitle">Balance:</span>
                            <span class="balance-title">{{ $balance }}</span>
                        </h5>
                    </div>
                    <div class="panel-body table-responsive">
                        <div class="pull-right text-right" id="ordersDTButtons"></div>
                        <table class="table" id="ordersTable">
                            <thead>
                                <tr>
                                    <th>Order</th>
                                    <th>Date</th>
                                    <th>Items</th>
                                    <th class="text-right"><span class="hidden-xs">Total </span>Points</th>
                                    <th>&nbsp;</th>
                                </tr>
                            </thead>
                            <tbody>
                            @forelse($orders as $order)
                                <tr>
                                    <td>{{ $order->number }}</td>
                                    <td>{{ $order->created_at->format('jS F, Y') }}</td>
                                    <td>{{ $order->totalQuantity()}}</td>
                                    <td class="text-right">{{ $order->totalPoints() }}</td>
                                    <td class="text-right">
                                        <a style="padding: 5px !important; min-width: auto;" class="btn btn-xs btn-default" href="{{ route('catalog.order.show', $order->number) }}">View</a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-danger text-center">No orders found.</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection

@section('js')
    @parent
    <script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.10.15/datatables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/rowgroup/1.0.0/js/dataTables.rowGroup.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.html5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.colVis.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.print.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.bootstrap.min.js"></script>
    <script type="text/javascript">
        $(document).ready(function(){
            $.extend( $.fn.dataTableExt.oStdClasses, {
                "sFilterInput": "dataTables_filter form-control",
                "sLengthSelect": "dataTables_length form-control select2"
            });
            var ordersDataTable = $('#ordersTable').DataTable({
                'order': [[0, 'desc']],
                columnDefs: [{orderable: false, targets: []}, {targets: [], visible: false} ],
                responsive: true,
                autoWidth: false,
                language: {
                    search: '',
                    searchPlaceholder: "Search...",
                    lengthMenu: '_MENU_'
                },
                buttons: []
            });

            ordersDataTable.buttons().container().appendTo($('#ordersDTButtons'));
        });
    </script>
@endsection
