@extends('layouts.site')
@section('meta_title', $catalog['wishlist_name'])

@section('content_header')
    @include('partials._components._heading', ['heading' => $catalog['wishlist_name'], 'image' => false, 'color' => 'blue'])
@endsection

@section('content')

    <section class="container">
        <div class="row">
            <div class="col-md-9 pull-right">
                <div class="panel mt-4 mb-4">
                    <div class="panel-heading">
                        @include('partials._catalog.toolbar.buttons')
                        <hr />
                    </div>
                    <div class="panel-body">
                        <div class="col-xs-12 section-30">
                            <table class="table table-responsive" id="cartItemsTable">
                                <thead>
                                    <tr>
                                        <th>&nbsp;</th>
                                        <th>Catalog #</th>
                                        <th>Item Name</th>
                                        <th class="text-right">Points</th>
                                        <th>&nbsp;</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @forelse($cart['lineitems'] as $item)
                                    <tr>
                                        <td>
                                            <a href="/catalog/item/{{ $item['catalog_item']['id'] }}">
                                                <img class="catalogThumb" src="{{ url('/catalog/images') . '/' . $catalog['image_path'] . '/' . $item['catalog_item']['image_filename'] . '.jpg'}}">
                                            </a>
                                        </td>
                                        <td>{{ $item['catalog_item']['full_catalog_number'] }}</td>
                                        <td>{{ $item['catalog_item']['item_name'] }}</td>
                                        <td class="text-right">{{ Format::amount($item['catalog_item']['points']) }}</td>
                                        <td nowrap>
                                            <a onclick="return confirm('Are you sure you want to remove this item?')" href="/catalog/deletefrom/{{ $cart['type'] }}/{{ $item['id'] }}" class="btn btn-danger">
                                                <span class="fa fa-remove" title="Remove from {{ ucwords($cart['type']) }}"></span>
                                            </a>
                                            <a href="/catalog/addto/cart/{{ $item['catalog_item']['id'] }}" class="btn btn-default">
                                                <span class="fa fa-shopping-cart text-primary" title="Add to Shopping Cart"></span>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="10"><h1>No Items in {{ ucwords($cart['type']) }}.</h1></td>
                                    </tr>
                                @endforelse
                                    @if ($cart['type'] == 'cart')
                                    <tr>
                                        <td>&nbsp</td>
                                        <td>&nbsp</td>
                                        <td class="text-right">Total:</td>
                                        <td class="text-right">{{ Format::amount($cartTotal) }}</td>
                                    </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 pull-left">
                <div class="panel mt-4 mb-4">
                    <div class="panel-body">
                        @include('partials._catalog.categories')
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection

@section('js')
    @parent
    <script>
        $(document).ready(function(){
            $('.menuHeader').click(function(){
                var id = $(this).attr('data-id');
                var plusMinus = $(this).html();
                $('.menuGroup').addClass('hidden');
                $('.menuHeader').html('+');
                if ( plusMinus == '+' ) {
                    $('.menuGroup[data-id="' + id + '"]').removeClass('hidden');
                    $(this).html('-');
                }
            });
        });
    </script>
@endsection