@extends('layouts.site')
@section('meta_title', 'Enrollment Review')

@section('content')

    <section class="container-centered-large">
        <div class="panel mt-4 mb-4">
            <div class="panel-heading">
                <div class="col-sm-10 col-sm-offset-1">
                    <h2 class="text-center">Registration</h2>
                    <p class="lead mt-4 mb-4">Please check the data below, feel free to make changes by hitting the "Back" button. If all of the information is correct, hit submit, and your registration will be processed and you will receive an email to create a password for your account.</p>
                </div>
            </div>
            <div class="panel-body">
                <form class="form-horizontal" id="form_participant" roll="form" method="post" action="/register/store">
                    {{ csrf_field() }}
                    <input type="hidden" name="code" value="{{ $code }}" />
                    @include('partials.participant.review.external', [
                        'dynamicFormLabelClass' => 'col-sm-4 text-left',
                        'dynamicFormControlClass' => 'col-sm-6',
                    ])
                    <hr />
                    <div class="form-group text-center">
                        <button class="btn btn-default" type="submit" name="backButton" value="Back">Back</button>
                        <button class="btn btn-primary" type="submit" name="submitButton" value="Submit">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </section>

@endsection