@extends('layouts.site')
@section('meta_title', 'Change Password')
@section('content_header')
    @include('partials._components._heading', ['heading' => 'Change Password'])
@endsection
@section('content')
    <section class="container">
        <div class="row">
            <div class="col-md-4">
                @include('partials._components._user-menu')
            </div>
            <div class="col-md-8">
                <div class="panel panel-default mt-4 mb-4">
                    <div class="panel-heading">
                        <div class="clearfix">
                            <strong class="panel-title pull-left" style="padding-top: 4px; text-shadow: 1px 1px 0 #fff;">{{ auth()->user()->fullName() }}</strong>
                            <div class="btn-group pull-right">
                                <a href="{{ route('participant.profile.edit') }}" class="btn btn-sm btn-default"><span class="fa fa-cog"></span> Edit Profile</a>
                                <a href="{{ route('participant.password.edit') }}" class="btn btn-sm btn-default"><span class="fa fa-key"></span> Change Password</a>
                            </div>
                        </div>
                    </div>
                    <div class="panel-body">
                        <div class="alert alert-flash alert-info alert-outline-border" style="margin: -14px -14px 35px;">
                            To update, enter your current and new passwords, then press the "Change" button below.<br />
                            Make sure you enter the same password for New Password and Confirm password.
                        </div>
                        {!! form($form) !!}
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
