<div class="modal " id="claimItemDialog" tabindex="-1" role="dialog" aria-labelledby="claimItemLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <strong class="modal-title" id="claimItemLabel">{{ __('Claim::claim.items.singular') }}</strong>
            </div>
            <div class="modal-body">
                <form id="addClaimItemForm" class="form-classic">
                    {{ csrf_field() }}
                    <input type="hidden" id="claimId" value="">
                    <input type="hidden" id="claimItemAction" value="">
                    @if (count($offerGroups) > 1)
                        <div class="form-group">
                            <label for="claimItemOfferGroup">{{ __('Claim::claim.items.group') }}</label>
                            <select style="display: block; width: 100%;" class="form-control" name="claimItemOfferGroup" id="claimItemOfferGroup" data-name="offer_group" required>
                                <option value="">{{ __('Core::core.select.default') }}</option>
                                @foreach($offerGroups as $name => $offerGroup)
                                    <option value="{{ $name }}">{{ $name }}</option>
                                @endforeach
                            </select>
                        </div>
                    @else
                        @php $groups = array_keys($offerGroups); @endphp
                        <input type="hidden" name="claimItemOfferGroup" id="claimItemOfferGroup" data-name="offer_group" value="{{ $groups[0] }}" readonly required />
                    @endif
                    <div class="form-group">
                        <label for="claimItemName">{{ __('Claim::claim.items.name') }}</label>
                        <input type="hidden" class="form-control" id="claimItemOfferId" name="claimItemOfferId" data-name="offer_id" value="{{ count($offerGroups) === 1 ? $offerGroups[$groups[0]][0]['offer_id'] : '' }}" />
                        @if (count($offerGroups) > 1)
                            <select style="display: block; width: 100%;" class="form-control" name="claimItemName" id="claimItemName" data-name="name" required></select>
                        @else
                            @php $groups = array_keys($offerGroups); @endphp
                            @if (isset($offerGroups[$groups[0]]) && count($offerGroups[$groups[0]]) > 1)
                                <select style="display: block; width: 100%;" class="form-control" name="claimItemName" id="claimItemName" data-name="name" required>
                                    @foreach ($offerGroups[$groups[0]] as $offer)
                                        <option value="{{ $offer['offer_id'] }}">{{ $offer['name'] }}</option>
                                    @endforeach
                                </select>
                            @else
                                <input type="text" class="form-control" name="claimItemName" id="claimItemName" data-name="name" value="{{ $offerGroups[$groups[0]][0]['name'] }}" readonly required />
                            @endif
                        @endif
                    </div>
                    <div class="form-group">
                        <label for="claimItemQty">{{ __('Claim::claim.items.quantity') }}</label>
                        <input type="text" class="form-control" id="claimItemQty" name="claimItemQty" data-name="qty" required/>
                    </div>
                </form>
            </div>
            <div class="modal-footer clearfix">
                <button style="margin: 0;" type="button" class="btn btn-danger offset-top-0 pull-left" data-dismiss="modal">{{ __('Core::core.buttons.cancel') }}</button>
                <button style="margin: 0;" type="button" class="btn btn-success hidden offset-top-0 pull-right" id="claimItemSave" data-item_number="">{{ __('Core::core.buttons.save') }}</button>
                <button style="margin: 0;" type="button" class="btn btn-success hidden offset-top-0 pull-right" id="claimItemAdd">{{ __('Core::core.buttons.add') }}</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal claimItemDialog -->
