@extends('layouts.site')
@section('meta_title', 'My Claims')
@section('content_header')
    @include('partials._components._heading', ['heading' => 'My Claims', 'image' => false, 'color' => 'blue'])
@endsection
@section('content')

    <section class="container">
        <div class="row">
            <div class="col-md-4">
                @include('partials._components._user-menu')
            </div>
            <div class="col-md-8">
                <div class="panel mt-4 mb-4">
                    <div class="panel-body nav-tabs-container">
                        <ul class="nav nav-tabs nav-tabs-custom">
                            <li class="active"><a href="#claim-summary" data-toggle="tab">Summary</a></li>
                            <li><a href="#claim-details" data-toggle="tab">Details</a></li>
                        </ul>
                        <div class="tab-content mt-3">
                            <div id="claim-summary" class="tab-pane fade in active">
                                <h4 class="mb-2 p-3 pt-2 negative-margin content-title">Summary</h4>
                                @if (! empty($statusTotals))
                                <div class="negative-margin">
                                    <table class="table table-striped mb-0" id="totalsTable">
                                        <thead>
                                            <tr>
                                                <th class="pl-3 text-left">Description</th>
                                                <th class="text-right">Count</th>
                                                <th class="pr-3 text-right">Total Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($statusTotals as $name => $statusTotal)
                                            <tr>
                                                <td class="pl-3 text-left">{{ $statusTotal['name'] }}</td>
                                                <td class="text-right">{{ number_format($statusTotal['count']) }}</td>
                                                <td class="pr-3 text-right">{{ number_format($statusTotal['amount']) }}</td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                @else
                                <div class="alert alert-danger">
                                    <strong>No claims submitted.</strong>
                                </div>
                                @endif
                            </div>
                            <div id="claim-details" class="tab-pane fade">
                                <h4 class="mb-2 p-3 pt-2 negative-margin content-title">Claim Details</h4>
                                @if (! empty($claimParticipants))
                                <div class="negative-margin">
                                    <table class="table table-striped mb-0" id="claimsTable">
                                        <thead>
                                            <tr>
                                                <th class="pl-3 text-left">Claim ID</th>
                                                <th>Date Submitted</th>
                                                <th>Status</th>
                                                <th class="pr-3 text-right">Claim Value</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @forelse($claimParticipants as $claimParticipant)
                                            <tr>
                                                <td class="pl-3 text-left">{{ $claimParticipant['claim']['id'] }}</td>
                                                <td>{{ Format::date($claimParticipant['claim']['created_at']) }}</td>
                                                <td>
                                                    @php
                                                    $status = trim(ucwords($claimParticipant['status']));
                                                    @endphp
                                                    @if ('Declined' === $status)
                                                        <span class="text-danger">{{ $status }}</span>
                                                    @elseif ('Approved' === $status)
                                                        <span class="text-success">{{ $status }}</span>
                                                    @elseif ('Cancelled' === $status)
                                                        <span class="label label-danger">{{ $status }}</span>
                                                    @elseif ('Issued' === $status)
                                                        <span class="label label-success">{{ $status }}</span>
                                                    @else
                                                        {{ $status }}
                                                    @endif
                                                </td>
                                                <td class="pr-3 text-right">{{ Format::amount($claimParticipant['value'], 0, 0) }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="4" class="text-danger text-center">No Claims found.</td>
                                            </tr>
                                        @endforelse
                                        </tbody>
                                    </table>
                                </div>
                                @else
                                    <div class="alert alert-danger">
                                        <strong>No claims submitted.</strong>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
